﻿<?php
/**
* @version          $Id: replaceabbr.php 6138 2007-07-02 03:44:18Z danr $
* @package          ReplaceAbbr
*/

// zablokuj bezpośrednie uruchamianie
defined( '_JEXEC' ) or die( 'Brak dostępu' );

class plgContentReplaceabbr extends JPlugin {
   // konstruktor kompatybilny z PHP4
   function plgContentReplaceabbr( & $subject ) {
      parent::__construct( $subject );
   }

   // Nazwa funkcji odpowiada nazwie zdarzenia
   function onPrepareContent(&$article, &$params, $limitstart=0) {
      // Pobierz wartość parametrów, na wypadek, gdyby były potrzebne później
      $plugin =& JPluginHelper::getPlugin('content', 'replaceabbr');
      $pluginParams = new JParameter( $plugin->params );
      $num =1;
      if (!$pluginParams->get('replace_limit', 1)) {
         $num = $pluginParams->get('replace_limit', 1);
      }

      if ( !JString::strpos( $article->text, '{replaceabbr=off}' ) === false ) {
         $article->text = str_replace( '{replaceabbr=off}',
           '', $article->text );
         return true;
      }

      $article->text =$this->replaceAbbrStr($article->text, $num);
      return true;
   }

   function replaceAbbrStr($myStr, $num) {
      // Utwórz tablicę zawierającą skróty
      $abbr=array("dot.","dr",
        "mgr", "np.",
        "wg", "ww.",
        "tj.", "tzn."
      );

      // Utwórz tablicę zawierającą rozwinięcia skrótów
      // Umieszczane są po dwa rozwinięcia w jednej linii,
      // co ułatwia dopasowanie do powyższej listy
      $actual=array("dotyczy", "doktor",
        "magister", "na przykład",
        "według", "wyżej wymienione",
        "to jest", "to znaczy"
      );

      // Dodaj znaki tworzące wyrażenie regularne ze skrótów,
      // aby dopasowywane były wyłącznie poprawne skróty,
      // dodatkowo ignoruj wielkość liter.
      for($i=0;$i < sizeof($abbr);$i++) {
         $abbr[$i] = "/\\b" . str_replace('.', '', $abbr[$i]) . "\\b\.?/i";
      }

      // Zastąp skróty za pomocą wyrażeń regularnych
      $myStr = preg_replace ( $abbr, $actual, $myStr, $num);
      // Return altered string
      return $myStr;
   }
}

$myPlugin =& new plgContentReplaceabbr(JDispatcher::getInstance() );

?>
