<?php
// Zapewnienie, e plik zosta doczony
defined('_JEXEC') or die( 'Brak dostpu' );

/**
 * Klasa JDocumentJSONRPC, ktra stanowi prosty interfejs
 * do wywietlania odpowiedzi JSON RPC.
 */
class JDocumentJSONRPC extends JDocument {
    
    var $_id = 0;
    
    var $_result = null;
    
    var $_error = null;
    
    /**
     * Konstruktor klasy
     *
     * @param array $options Tablica asocjacyjna opcji
     */
    function __construct($options = array()) {
        // wykonanie odpowiednich czynnoci przez klas przodka
        parent::__construct($options);
        
        // ustawienie typu mime
        $this->setMimeEncoding("application/json");
    }
    
    /**
     * Ustawia identyfikator odpowiedzi. Warto powinna by zawsze 
     * identyczna jak identyfikator przychodzcego dania.
     *
     * @param  int    $id Identyfikator odpowiedzi
     * @access public
     */
    function setId($id) {
        $this->_id = intval($id);
    }
    
    /**
     * Ustawia wynik wywoania procedury.
     *
     * @param  mixed  $result Wynik wywoania procedury
     * @access public
     */
    function setResult($result) {
        // oprnienie strumienia bdw  nie bdzie nam ju potrzebny
        $this->_error  = null;
        
        // zdefiniowanie wyniku
        $this->_result = $result;
    }
    
    /**
     * Ustawienie bdu
     *
     * @param  int    $code    Kod bdu
     * @param  string $message Komunikat bdu
     * @access public
     */
    function setError($code, $message) {
        // oprnienie strumienia bdw  nie bdzie nam ju potrzebny
        $this->_result = null;
        
        // zdefiniowanie obiektu bdu
        $this->_error = new stdClass();
        $this->_error->code = intval($code);
        $this->_error->message = (string)$message;
    }

    function render($cache = false, $params = array()) {
        // utworzenie obiektu odpowiedzi
        $response          = new stdClass();
        $response->jsonrpc = "2.0";
        $response->id      = $this->_id;
        
        // ustawienie bdu lub wyniku
        // s to dwa przypadki wzajemnie si wykluczajce
        if (is_object($this->_error)) {
            $response->error = $this->_error;
        } else {
            $response->result = $this->_result;
        }
        
        // nagwki niech obsuy klasa rodzica
        parent::render($cache, $params);
        
        // zwrcenie odpowiedzi JSON-RPC
        return json_encode($response);
    }
    
}

?>