<?php
// Zapewnienie, e plik zosta doczony
defined('_JEXEC') or die( 'Brak dostpu' );

/**
 * Dekoduje dane z dania JSON-RPC wykonanego metod POST
 *
 * @return mixed obiekt dania lub warto false w przypadku niepowodzenia
 */
function getJSON_RPC_Request() {
    // obsuguje wycznie dania metod POST
    if (JRequest::getVar("REQUEST_METHOD", null, "SERVER") != "POST") {
        $document->setError(-32600, "danie nieprawidowe.");
        return false;
    }
    
    // pobranie nieprzetworzonych danych POST i ich zdekodowanie
    $rawRequest = file_get_contents("php://input");
    $request    = json_decode($rawRequest);

    // sprawdzenie, czy danie zostao pomylnie zdekodowane
    if ($request == null) {
        $document->setError(-32700, "Bd parsowania.");
        return false;
    }

    // sprawdzenie, czy danie jest obiektem
    if (!is_object($request)) {
        $document->setError(-32600, "danie nieprawidowe.");
        return false;
    }

    // sprawdzenie, czy obiekt dania jest prawidowy
    $vars = get_object_vars($request);
    if (!array_key_exists("method", $vars) ||
        !array_key_exists("jsonrpc", $vars)) {
        $document->setError(-32600, "danie nieprawidowe.");
        return false;
    }

    // ustawienie identyfikatora odpowiedzi, jeeli wskazano identyfikator
    if (array_key_exists("id", $vars)) {
        $document->setId($request->id);
    }

    // wszystko zrobione!
    return $request;
}
?>