package com.journaler

import com.journaler.api.ApiApplication
import com.journaler.api.data.TodoDTO
import com.journaler.api.service.TodoService
import org.junit.Assert
import org.junit.Before
import org.junit.Test
import org.junit.runner.RunWith
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.test.context.SpringBootTest
import org.springframework.test.context.junit4.SpringRunner

@RunWith(SpringRunner::class)
@SpringBootTest(classes = [ApiApplication::class])
class TodoTest {

  @Autowired
  private lateinit var service: TodoService

  private val todos = mutableListOf<TodoDTO>()

  @Before
  fun prepare() {
    Assert.assertNotNull(service)
    // Przygotowanie 10 zadań.
    (1..10).mapTo(todos) {
      TodoDTO(
        "Tytuł testowego zadania: $it",
        "Treść testowego zadania: $it",
        System.currentTimeMillis()
      )
    }
  }

  @Test
  fun crud() {
    // Test operacji CRUD na zadaniach.
    cleanup()   // Usunięcie danych z bazy przed rozpoczęciem testu.
    insert()    // Zapisanie w bazie przygotowanych wcześniej zadań.
    update()    // Modyfikacja każdego zadania.
    select()    // Sprawdzenie, czy zadania zostały zapisane.
    delete()    // Usunięcie zadań z bazy.  
  }

  fun cleanup() {
    service.getTodos().forEach { todo ->
      service.deleteTodo(todo.id)
    }
  }

  fun insert() {
    todos.forEach { todo ->
      val result = service.insertTodo(todo)
      Assert.assertNotNull(result)
      Assert.assertNotNull(result.id)
      Assert.assertFalse(result.id.isEmpty())
      Assert.assertTrue(result.schedule > 0)
      todo.id = result.id
    }
  }

  fun update() {
    todos.forEach { todo ->
      todo.title = "Zmieniony tytuł"
      todo.message = "Zmieniona treść"
      val result = service.updateTodo(todo)
      Assert.assertNotNull(result)
      Assert.assertNotNull(result.id)
      Assert.assertFalse(result.id.isEmpty())
      Assert.assertEquals("Zmieniony tytuł", result.title)
      Assert.assertEquals("Zmieniona treść", result.message)
      Assert.assertTrue(result.schedule > 0)
    }
  }

  fun delete() {
    todos.forEach { todo ->
      println("Usunięcie zadania o identyfikatorze ${todo.id}")
      service.deleteTodo(todo.id)
    }
  }

  fun select() {
    val result = service.getTodos()
    result.forEach { todo ->
      Assert.assertNotNull(todo)
      Assert.assertNotNull(todo.id)
      Assert.assertFalse(todo.id.isEmpty())
      Assert.assertEquals("Zmieniony tytuł", todo.title)
      Assert.assertEquals("Zmieniona treść", todo.message)e)
      Assert.assertTrue(todo.schedule > 0)
    }
  }

}