package com.journaler.gateway.security

import org.springframework.security.config.annotation.web.builders.HttpSecurity
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.Configuration
import org.springframework.core.annotation.Order
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity

@Configuration
@EnableWebSecurity
@Order(1)
class SecurityConfig : WebSecurityConfigurerAdapter() {

  @Autowired
  fun configureGlobal(auth: AuthenticationManagerBuilder) {
    auth
      .inMemoryAuthentication()
      .withUser("user")
      .password("12345")
      .roles("USER")
      .and()
      .withUser("admin")
      .password("12345")
      .roles("ADMIN")
  }

  override fun configure(http: HttpSecurity) {
    http
      .authorizeRequests()
      .antMatchers("/journaler/**")
      .permitAll()
      .antMatchers("/eureka/**").hasRole("ADMIN")
      .anyRequest().authenticated()
      .and()
      .formLogin()
      .and()
      .logout().permitAll()
      .logoutSuccessUrl("/journaler/**").permitAll()
      .and()
      .csrf().disable()
  }

}