// Copyright © 2016 Alan A. A. Donovan & Brian W. Kernighan.
// License: https://creativecommons.org/licenses/by-nc-sa/4.0/


// Dedup wyświetla tylko jedną instancję każdej linii; duplikaty są usuwane.
package main

import (
	"bufio"
	"fmt"
	"os"
)

//!+
func main() {
	seen := make(map[string]bool) // zbiór łańcuchów znaków
	input := bufio.NewScanner(os.Stdin)
	for input.Scan() {
		line := input.Text()
		if !seen[line] {
			seen[line] = true
			fmt.Println(line)
		}
	}

	if err := input.Err(); err != nil {
		fmt.Fprintf(os.Stderr, "dedup: %v\n", err)
		os.Exit(1)
	}
}

//!-
