describe('Przekrojowe testy aplikacji Aurelia', () => {

  beforeEach( () => {
    browser.get('http://localhost:9000');
    browser.sleep(1000);
  });

  it('powinien wczytać stronę', () => {
      expect(browser.getTitle()).toBe('Aurelia');
  });

  it('powinien znaleźć element h1 z tekstem "Wybierz"', () => {
    expect(element(by.css('h1'))
      .getText()).toContain("Wybierz");
  });

  it('powinien znaleźć informację, że nie wybrano elementu', () => {
    expect(element(by.id('selectedElement'))
      .getText()).toBe('Wybrany element: 0 - none');
  });

  it('powinien znaleźć pierwszy przycisk', () => {
    expect(element(by.id('select_button_0'))
      .getText()).toBe("pierwszyElement");
  });

  it('kliknięcie przycisku powinno zaktualizować wybrany element', () => {
    element(by.id('select_button_0')).click();
    browser.sleep(500);
    expect(element(by.id('selectedElement'))
      .getText()).toBe('Wybrany element: 1 - pierwszyElement');
  });

});

//https://addons.mozilla.org/en-US/firefox/addon/selenium-ide/

