module.exports = {
  entry: "./app/index.tsx",
  output: {
    filename: "bundle.js",
    path: __dirname + "/dist"
  },

  // Włączenie map źródłowych do debugowania wyników generowanych przez webpack.
  devtool: "source-map",

  resolve: {
    // Dodanie '.ts' oraz '.tsx' jako rozpoznawalnych rozszerzeń.
    extensions: [".webpack.js", ".web.js", ".ts", ".tsx", ".js"]
  },

  module: {
    rules: [
      // Wszystkie pliki z rozszerzeniami '.ts' lub '.tsx' 
      // będą obsługiwane przez 'ts-loader'.
      { test: /\.tsx?$/, loader: "ts-loader" },

      // Wszelkie mapy źródłowe wszystkich plików '.js' 
      // będą ponownie przetwarzane przez 'source-map-loader'.
      { enforce: "pre", test: /\.js$/, loader: "source-map-loader" }
    ]
  },

  externals: {
    "react": "React",
    "react-dom": "ReactDOM"
  },
};