//"use strict"
import "reflect-metadata";

console.log("Przykłady do rozdziału 4.");


//  Dekoratory
//  ==========


//  składnia dekoratorów
//  ================

function simpleDecorator(constructor : Function) {
  console.log('Wywołano funkcję simpleDecorator.');
}

@simpleDecorator
class ClassWithSimpleDecorator {
  
}

let instance_1 = new ClassWithSimpleDecorator();
let instance_2 = new ClassWithSimpleDecorator();

console.log(`instance_1 : ${instance_1}`);
console.log(`instance_2 : ${instance_2}`);


function secondDecorator(constructor : Function) {
  console.log('Wywołano funkcję secondDecorator.')
}

@simpleDecorator
@secondDecorator
class ClassWithMultipleDecorators {  
}

//  fabryki dekoratorów
//  ===================

function decoratorFactory(name: string) {
  return function (constructor : Function ) {
    console.log(`funkcja dekortora wywołana z parametrem : ${name}`);
  }
}

@decoratorFactory('nazwaTestowa')
class ClassWithDecoratorFactory {
}

//  parametry dekoratorów klas
//  ==========================

function classConstructorDec(constructor: Function) {
  console.log(`constructor : ${constructor}`);
  console.log(`constructor.name : ${(<any>constructor).name}`);
  constructor.prototype.testProperty = "wartość_testProperty";
}

@classConstructorDec
class ClassWithConstructor {
}

let classConstrInstance = new ClassWithConstructor();
console.log(`classConstrInstance.testProperty : ` 
  + `${(<any>classConstrInstance).testProperty}`);
  

//  dekoratory właściwości
//  ===================

function propertyDec(target: any, propertyKey : string) {
  console.log(`target: ${target}`);
  console.log(`target.constructor: ${target.constructor}`);
  console.log(`target.constructor.name: `
  + `${target.constructor.name}`);
  console.log(`propertyKey: ${propertyKey}`);
}

class ClassWithPropertyDec {
  @propertyDec
  name: string;
}


//function propertyDec(target: any, propertyKey : string) {
//  // console.log(`target : ${target}`);
//  // console.log(`target.constructor : ${target.constructor}`);
//  
//  if(typeof(target) === 'function') {
//    console.log(`nazwa klasy: ${target.name}`);
//  } else {
//    console.log(`nazwa klasy: ${target.constructor.name}`);    
//  }
//  
//  console.log(`propertyKey : ${propertyKey}`);
//}


//class ClassWithPropertyDec {
//  @propertyDec
//  propname: string;
//}

class StaticClassWithPropertyDec {
  @propertyDec
  static propname: string;
}


//  dekoratory metod
//  =================

function methodDec (target: any, 
  methodName: string, 
  descriptor?: PropertyDescriptor) {
    console.log(`target: ${target}`);
    console.log(`methodName: ${methodName}`);
    console.log(`target[methodName]: ${target[methodName]}`);
}

class ClassWithMethodDec {
  @methodDec
  print(output: string) {
    console.log(`Wywołano metodę ` 
      + `ClassWithMethodDec.print(${output}).`);
  }
}

//  stosowanie dekoratorów metod
//  =======================

function auditLogDec(target: any, 
  methodName: string, 
  descriptor?: PropertyDescriptor ) {
    
  let originalFunction = target[methodName];
  
  let auditFunction = function() {
    console.log(`auditLogDec: wywołano podmienioną ` 
      + `wersję metody ${methodName}. `);
    originalFunction.apply(this, arguments);
  }
  
  target[methodName] = auditFunction;
  return target;
}

class ClassWithAuditDec {
  @auditLogDec
  print(output: string) {
    console.log(`Wywołano metodę ` 
    + `ClassWithMethodDec.print(${output}).`);
  }
}

let auditClass = new ClassWithAuditDec();
auditClass.print("testy");


//  dekoratory parametrów
//  ====================


function parameterDec(target: any, 
  methodName : string, 
  parameterIndex: number) {
  
  console.log(`target: ${target}`);
  console.log(`methodName : ${methodName}`);
  console.log(`parameterIndex : ${parameterIndex}`);    
    
}

class ClassWithParamDec {
  print(@parameterDec  value: string) {
  }
}


//  metadane dekoratorów
//  ==================

// należy wykonać następujące polecenia: 
// npm install reflect-metadata --save
// npm install @types/reflect-metadata --save

import 'reflect-metadata';

function metadataParameterDec(target: any, 
  methodName : string, 
  parameterIndex: number) {

   let designType = Reflect.getMetadata(
     "design:type", target, methodName);
   console.log(`designType: ${designType}`)    
   
   let designParamTypes = Reflect.getMetadata(
     "design:paramtypes", target, methodName);
   console.log(`paramtypes : ${designParamTypes}`);
   
   let designReturnType = Reflect.getMetadata(
     "design:returntype", target, methodName);
   console.log(`returntypes : ${designReturnType}`);
}


class ClassWithMetaData {
  print( 
    @metadataParameterDec 
    id: number, 
    name: string) : number {
    return 1000;
  }
}
//*/


//  typy ogólne
//  ========

class Concatenator< T > {
  concatenateArray(inputArray: Array< T >): string {
    let returnString = "";

    for (let i = 0; i < inputArray.length; i++) {
      if (i > 0)
        returnString += ",";
      returnString += inputArray[i].toString();
    }
    return returnString;
  }
}

var stringConcat = new Concatenator<string>();
var numberConcat = new Concatenator<number>();

let concatResult = stringConcat.concatenateArray(
  ["pierwszy", "drugi", "trzeci"]);
console.log(concatResult);

var stringArray: string[] = ["pierwszy", "drugi", "trzeci"];
var numberArray: number[] = [1, 2, 3];
var stringResult = 
  stringConcat.concatenateArray(stringArray);
var numberResult = 
  numberConcat.concatenateArray(numberArray);
// var stringResult2 = 
//     stringConcat.concatenateArray(numberArray);
// var numberResult2 = 
//     numberConcat.concatenateArray(stringArray);

class MyClass {
  private _name: string;
  constructor(arg1: number) {
    this._name = arg1 + "_MyClass";
  }
  toString(): string {
    return this._name;
  }
}

let myArray: MyClass[] = [
  new MyClass(1), 
  new MyClass(2), 
  new MyClass(3)];
  
let myArrayConcatentator = new Concatenator<MyClass>();
let myArrayResult = 
  myArrayConcatentator.concatenateArray(myArray);
console.log(myArrayResult);


//  ograniczanie typu T
//  ==========================

enum ClubHomeCountry {
  England,
  Germany
}

interface IFootballClub {
  getName() : string;
  getHomeCountry(): ClubHomeCountry;
}

abstract class FootballClub implements IFootballClub {
  protected _name: string;
  protected _homeCountry: ClubHomeCountry;
  getName() { return this._name };
  getHomeCountry() { return this._homeCountry };
}

class Liverpool extends FootballClub {
  constructor() {
    super();
    this._name = "Liverpool F.C.";
    this._homeCountry = ClubHomeCountry.England;
  }
}

class BorussiaDortmund extends FootballClub {
  constructor() {
    super();
    this._name = "Borussia Dortmund";
    this._homeCountry = ClubHomeCountry.Germany;
  }
}

class FootballClubPrinter< T extends IFootballClub  >
  implements IFootballClubPrinter< T > {
  print(arg : T) {
    console.log(` ${arg.getName()}` +
      `${this.IsEnglishTeam(arg)}` +
      `jest drużyną angielską.`
    );
  }
  IsEnglishTeam(arg : T) : string {
    if ( arg.getHomeCountry() == ClubHomeCountry.England ) 
      return "";
    else
      return "NIE "
  }
}

let clubInfo = new FootballClubPrinter();
clubInfo.print(new Liverpool());
clubInfo.print(new BorussiaDortmund());

interface IFootballClubPrinter < T extends IFootballClub > {
  print(arg : T);
  IsEnglishTeam(arg : T);
}


//  Creating new objects
//  ====================


class FirstClass {
  id: number;
}

class SecondClass {
  name: string;
}

class GenericCreator< T > {
  create(arg1: { new(): T }) : T {
    return new arg1();
  }
}

var creator1 = new GenericCreator<FirstClass>();
var firstClass: FirstClass = creator1.create(FirstClass);

var creator2 = new GenericCreator<SecondClass>();
var secondClass : SecondClass = creator2.create(SecondClass);



//  obietnice, async i await oraz programowanie asynchroniczne
//  ===========

// Koniecznie należy zagwarantować, że zainstalowan jest wersją nodejs 4
// lub nowsza: 

// sudo apt-key adv --keyserver keyserver.ubuntu.com --recv 68576280
// sudo apt-add-repository 'deb https://deb.nodesource.com/node_4.x precise main'
// sudo apt-get update
// sudo apt-get install nodejs


//  obietnice
//  ========


function delayedResponseWithCallback(callback: Function) {
  function delayedAfterTimeout() {
    console.log(`delayedAfterTimeout`);
    callback();
  }
  setTimeout(delayedAfterTimeout, 1000);
}

function callDelayedAndWait() {
  function afterWait() {
    console.log(`afterWait`);
  }
  console.log(`przed wywołaniem funkcji delayedResponseWithCallback`);
  delayedResponseWithCallback(afterWait);
  console.log(`po wywołaniu funkcji callng delayedResponseWithCallback`);
}

callDelayedAndWait();


//  składnia obietnic
//  ==============

function fnDelayedPromise (
  resolve: () => void, 
  reject : () => void) 
  {
    function afterTimeout() {
       resolve();
    }
    
    setTimeout( afterTimeout, 2000);
  }

function delayedResponsePromise() : Promise<void> {
  return new Promise<void>(
    fnDelayedPromise
  );
}


function delayedPromise() : Promise<void> {
  return new Promise<void> 
  ( 
    ( resolve : () => void, 
      reject: () => void 
    ) => {
      function afterTimeout() {
        resolve();
      }
      
      setTimeout( afterTimeout, 1000);
    } 
  );
}


function callDelayedPromise() {
  console.log(`wywołujemy obietnicę delayedPromise`);
  delayedPromise().then(
    () => { console.log(`delayedPromise.then()`) }
  );
}

callDelayedPromise();

function errorPromise() : Promise<void> {
  return new Promise<void> 
  (
    ( resolve: () => void, 
      reject: () => void
    ) => {
      reject();
    }  
  );
}

function callErrorPromise() {
  console.log(`wywołujemy obietnicę errorPromise`);
  errorPromise().then(
    () => { console.log(`Nie ma błędu.`) }
  ).catch(
    () => { console.log(`Wystąpił błąd.`)}
  );
}

callErrorPromise();

function invokeAsync(success: Function, error : Function) {
  
}

function standardCallback() {
  function afterCallbackSuccess() {
    // kod wykonywany w przypadku powodzenia
  }
  function afterCallbackError() {
    // kod wykonywany w przypadku błędu
  }
  // wywołanie funkcji asynchronicznej
  invokeAsync(afterCallbackSuccess, afterCallbackError);
}

function usingPromises() {
  // wywołanie funkcji asynchronicznej
  delayedPromise().then(
    () => { 
      // kod wykonywany w przypadku powodzenia
    }
  ).catch (
    () => {
      // kod wykonywany w przypadku błędu
    }
  );
}


function delayedPromiseWithParam() : Promise<string> {
  return new Promise<string>( 
    (
      resolve: (str: string ) => void, 
      reject: (str:string ) => void 
    ) => {
      function afterWait() {
        resolve("wyznaczono_w_obietnicy");
      }
      setTimeout( afterWait , 2000 );
    } 
  );
}

function callPromiseWithParam() {
  console.log(`wywołujemy obietnicę delayedPromiseWithParam`);
  delayedPromiseWithParam().then( (message: string) => {
    console.log(`wywołanie Promise.then() zwróciło: ${message} `);
  } );
}

callPromiseWithParam();


interface IPromiseMessage {
  message: string;
  id: number;
}

function promiseWithInterface() : Promise<IPromiseMessage> {
  return new Promise<IPromiseMessage> (
    ( 
      resolve: (message: IPromiseMessage) => void,
      reject: (message: IPromiseMessage) => void
    )  => {
      resolve({message: "test", id: 1});
    }
  );
}

//  słowa kluczowe async i await
//  ===========

function awaitDelayed() : Promise<void> {
  return new Promise<void> (
    ( resolve: () => void,
      reject: () => void ) => 
      {
        function afterWait() {
          console.log(`wywołujemy funkcję zwrotną resolve`);
          resolve();
        }    
        setTimeout(afterWait, 1000);
      }
  );
}

async function callAwaitDelayed() {
  console.log(`wywołujemy funkcję awaitDelayed`);
  await awaitDelayed();
  console.log(`po wywołaniu funkcji awaitDelayed`);
}

callAwaitDelayed();


//  słowo kluczowe async i obsługa błędów
//  ============

function awaitError() : Promise<string> {
  return new Promise<string> (
    ( resolve: (message: string) => void,
      reject: (error: string) => void ) => 
      {
       function afterWait() {
         console.log(`wywołujemy metodę zwrotną reject`);
         reject("wystąpił błąd");
       }    
       setTimeout(afterWait, 1000);
      }
  );
}

async function callAwaitError() {
  console.log(`wywołujemy funkcję awaitError`);
  try {
    await awaitError();
  } catch (error) {
    console.log(`zwrócono błąd : ${error}`);
  }
  console.log(`po wywołaniu funkcji awaitDelayed`);
}

callAwaitError();


function simplePromises() {
  // wywołanie funkcji asynchronicznej
  delayedPromise().then(
    () => { 
      // kod wykonywany w razie prawidłowego
      // wyznaczenia obietnicy
    }
  ).catch (
    () => {
      // kod wywoływany w razie wystąpienia błędu
    }
  );
  // kod umieszczony w tym miejscu NIE będzie
  // czekał na zakończenie wykonywania funkcji asynchronicznej
}

async function usingAsyncSyntax() {
  try {
    await delayedPromise();
    // kod wykonywany w razie pomyślnego wyznaczenia obietnicy
  } catch(error) {
    // kod wykonyway w przypadku, gdy podczas wyznaczania 
    // obietnicy wystąpiły jakieś błędy
  }
  // ten kod zostanie wykonany dopiero po zakończeniu 
  // funkcji asynchronicznej
}


function asyncWithMessage() : Promise<string> {
  return new Promise<string> (
    ( resolve: (message: string ) => void,
      reject: (message: string) => void
    ) => {
      function afterWait() {
        resolve("komunikat_wyznaczenia_obietnicy");
      }
      setTimeout(afterWait, 1000);
    }
  );
}


async function awaitMessage() {
  console.log(`wywołujemy funkcję asyncWithMessage`);
  let message: string = await asyncWithMessage();
  
  console.log(`zwrócono komunikat: ${message}`);
}

awaitMessage();

//*/