import { Mediator,
  IMediatorImpl,
  StateType,
  PanelType,
  MainPanelOnly,
  MainPanelWithSideNav,
  LoginPanel } from '../app/state.mediator';

class MockMediatorImpl implements IMediatorImpl {
  showNavPanel() {}
  hideNavPanel() {}
  showDetailPanel() {}
  hideDetailPanel() {}
  changeShowHideSideButton(fromClass: string, toClass: string) {};
  showLoginPanel() {};
  hideLoginPanel() {};    
}

describe('src/tests/state.mediator.spec.ts', () => {
  let mockMediatorImpl : IMediatorImpl;
  beforeEach(() => {
    mockMediatorImpl = new MockMediatorImpl();
  });

  it('powinien być ustawiony stan początkowy aplikacji', () => {
    let mediator = new Mediator(mockMediatorImpl);
    expect(mediator.getCurrentMainPanelState())
    .toBe(StateType.MainPanelWithSideNav);
  });

  it('powinna zostać wywołana funkcja hideNavPanel', () => {
    let spy = spyOn(mockMediatorImpl, 'hideNavPanel');
    let mediator = new Mediator(mockMediatorImpl);

    mediator.moveToState(StateType.MainPanelOnly);
    expect(spy).toHaveBeenCalled();
  });

  it('powinien zostać zapisany stan MainPanelState z ukrytym panelem nawigacyjnym', () => {
    let mediator = new Mediator(mockMediatorImpl);
    mediator.moveToState(StateType.MainPanelOnly);
    expect(mediator.getCurrentMainPanelState())
      .toBe(StateType.MainPanelOnly);
  });

  it('powinien zostać utworzony obiekt stanu LoginPanel zwracający odpowiednie wartości', () => {
    let loginState = new LoginPanel();
    expect(loginState.getPanelType()).toBe(PanelType.OverlayPanel);
    expect(loginState.getStateType()).toBe(StateType.LoginPanel);
    expect(loginState.isLoginVisible()).toBe(true);
  });

  it('powinna zostać wywołana funkcja showLoginPanel', () => {
    let spy = spyOn(mockMediatorImpl, 'showLoginPanel');
    let mediator = new Mediator(mockMediatorImpl);

    mediator.moveToState(StateType.LoginPanel);

    expect(spy).toHaveBeenCalled();
  });

});


