
df <- tibble::tibble(
  a = rnorm(10),
  b = rnorm(10),
  c = rnorm(10),
  d = rnorm(10)
)

df$a <- (df$a - min(df$a, na.rm = TRUE)) / 
  (max(df$a, na.rm = TRUE) - min(df$a, na.rm = TRUE))
df$b <- (df$b - min(df$b, na.rm = TRUE)) / 
  (max(df$b, na.rm = TRUE) - min(df$a, na.rm = TRUE))
df$c <- (df$c - min(df$c, na.rm = TRUE)) / 
  (max(df$c, na.rm = TRUE) - min(df$c, na.rm = TRUE))
df$d <- (df$d - min(df$d, na.rm = TRUE)) / 
  (max(df$d, na.rm = TRUE) - min(df$d, na.rm = TRUE))

(df$a - min(df$a, na.rm = TRUE)) /
  (max(df$a, na.rm = TRUE) - min(df$a, na.rm = TRUE))

x <- df$a
(x - min(x, na.rm = TRUE)) / (max(x, na.rm = TRUE) - min(x, na.rm = TRUE))

rng <- range(x, na.rm = TRUE)
(x - rng[1]) / (rng[2] - rng[1])

rescale01 <- function(x) {
  rng <- range(x, na.rm = TRUE)
  (x - rng[1]) / (rng[2] - rng[1])
}
rescale01(c(0, 5, 10))

rescale01(c(-10, 0, 10))
rescale01(c(1, 2, 3, NA, 5))

df$a <- rescale01(df$a)
df$b <- rescale01(df$b)
df$c <- rescale01(df$c)
df$d <- rescale01(df$d)

x <- c(1:10, Inf)
rescale01(x)

rescale01 <- function(x) {
  rng <- range(x, na.rm = TRUE, finite = TRUE)
  (x - rng[1]) / (rng[2] - rng[1])
}
rescale01(x)

mean(is.na(x))

x / sum(x, na.rm = TRUE)

sd(x, na.rm = TRUE) / mean(x, na.rm = TRUE)

is_directory <- function(x) file.info(x)$isdir
is_readable <- function(x) file.access(x, 4) == 0

# Zbyt krótka
f()

# Ani czasownik, ani opis 
my_awesome_function()

# Długa, ale czytelna
impute_missing()
collapse_years()

# Nigdy tego nie rób!
col_mins <- function(x, y) {}
rowMaxes <- function(y, x) {}

# Dobrze
input_select()
input_checkbox()
input_text()

# Niezbyt dobrze
select_input()
checkbox_input()
text_input()

# Nie rób tego!
T <- FALSE
c <- 10
mean <- function(x) sum(x)

# Wczytywanie danych --------------------------------------

# Wyświetlanie danych --------------------------------------

f1 <- function(string, prefix) {
  substr(string, 1, nchar(prefix)) == prefix
}
f2 <- function(x) {
  if (length(x) <= 1) return(NULL)
  x[-length(x)]
}
f3 <- function(x, y) {
  rep(y, length.out = length(x))
}

if (condition) {
  # kod wykonywany, gdy warunek ma wartość TRUE
} else {
  # kod wykonywany, gdy warunek ma wartość FALSE
}

has_name <- function(x) {
  nms <- names(x)
  if (is.null(nms)) {
    rep(FALSE, length(x))
  } else {
    !is.na(nms) & nms != ""
  }
}

if (c(TRUE, FALSE)) {}

if (NA) {}

identical(0L, 0)

x <- sqrt(2) ^ 2
x
x == 2
x - 2

if (this) {
  # zrób coś	
} else if (that) {
  # zrób coś innego
} else {
  # 
}

function(x, y, op) {
  switch(op,
         plus = x + y,
         minus = x - y,
         times = x * y,
         divide = x / y,
         stop("Unknown op!")
  )
}

# Dobrze
if (y < 0 && debug) {
  message("Y jest ujemne")
}

if (y == 0) {
  log(x)
} else {
  y ^ x
}

# Źle
if (y < 0 && debug)
  message("Y jest ujemne")

if (y == 0) {
  log(x)
} else {
  y ^ x
}

y <- 10
x <- if (y < 20) "Za mało" else "Za dużo"

if (y < 20) {
  x <- "Za mało" 
} else {
  x <- "Za dużo"
}

if (temp <= 0) {
  "lodowato"
} else if (temp <= 10) {
  "zimno"
} else if (temp <= 20) {
  "chłodno"
} else if (temp <= 30) {
  "ciepło"
} else {
  "gorąco"
}

switch(x, 
       a = ,
       b = "ab",
       c = ,
       d = "cd"
)

# Obliczanie przedziału ufności dla średniej 
# za pomocą aproksymacji rozkładem normalnym
mean_ci <- function(x, conf = 0.95) {
  se <- sd(x) / sqrt(length(x))
  alpha <- 1 - conf
  mean(x) + se * qnorm(c(alpha / 2, 1 - alpha / 2))
}

x <- runif(100)
mean_ci(x)
mean_ci(x, conf = 0.99)

# Dobrze
mean(1:10, na.rm = TRUE)

# Źle
mean(x = 1:10, , FALSE)
mean(, TRUE, x = c(1:10, NA))

# Dobrze
average <- mean(feet / 12 + inches, na.rm = TRUE)

# Źle
average<-mean(feet/12+inches,na.rm=TRUE)

wt_mean <- function(x, w) {
  sum(x * w) / sum(w)
}
wt_var <- function(x, w) {
  mu <- wt_mean(x, w)
  sum(w * (x - mu) ^ 2) / sum(w)
}
wt_sd <- function(x, w) {
  sqrt(wt_var(x, w))
}

wt_mean(1:6, 1:3)

wt_mean <- function(x, w) {
  if (length(x) != length(w)) {
    stop("`x` i `w` muszą mieć jednakową długość", call. = FALSE)
  }
  sum(w * x) / sum(w)
}

wt_mean <- function(x, w, na.rm = FALSE) {
  if (!is.logical(na.rm)) {
    stop("`na.rm` musi być wartością logiczną")
  }
  if (length(na.rm) != 1) {
    stop("`na.rm` musi mieć długość 1")
  }
  if (length(x) != length(w)) {
    stop("`x` i `w` muszą mieć jednakową długość", call. = FALSE)
  }
  
  if (na.rm) {
    miss <- is.na(x) | is.na(w)
    x <- x[!miss]
    w <- w[!miss]
  }
  sum(w * x) / sum(w)
}

wt_mean <- function(x, w, na.rm = FALSE) {
  stopifnot(is.logical(na.rm), length(na.rm) == 1)
  stopifnot(length(x) == length(w))
  
  if (na.rm) {
    miss <- is.na(x) | is.na(w)
    x <- x[!miss]
    w <- w[!miss]
  }
  sum(w * x) / sum(w)
}
wt_mean(1:6, 6:1, na.rm = "foo")

sum(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
stringr::str_c("a", "b", "c", "d", "e", "f")

commas <- function(...) stringr::str_c(..., collapse = ", ")
commas(letters[1:10])

rule <- function(..., pad = "-") {
  title <- paste0(...)
  width <- getOption("width") - nchar(title) - 5
  cat(title, " ", stringr::str_dup(pad, width), "\n", sep = "")
}
rule("Ważny wynik")

x <- c(1, 2)
sum(x, na.mr = TRUE)

complicated_function <- function(x, y, z) {
  if (length(x) == 0 || length(y) == 0) {
    return(0)
  }
  
  # Miejsce na skomplikowany kod
}

f <- function() {
  if (x) {
    # Zrób
    # coś
    # co
    # wymaga
    # wielu
    # wierszy
    # kodu
  } else {
    # zwróć coś krótkiego
  }
}


f <- function() {
  if (!x) {
    return(something_short)
  }
  
  # Zrób
  # coś
  # co
  # wymaga
  # wielu
  # wierszy
  # kodu
}

show_missings <- function(df) {
  n <- sum(is.na(df))
  cat("Brakujące wartości: ", n, "\n", sep = "")
  
  invisible(df)
}

show_missings(mtcars)

x <- show_missings(mtcars) 
class(x)
dim(x)

library(dplyr)

mtcars %>% 
  show_missings() %>% 
  mutate(mpg = ifelse(mpg < 20, NA, mpg)) %>% 
  show_missings() 

f <- function(x) {
  x + y
}

  y <- 100
  f(10)
  
  y <- 1000
  f(10)
  
  `+` <- function(x, y) {
    if (runif(1) < 0.1) {
      sum(x, y)
    } else {
      sum(x, y) * 1.1
    }
  }
  table(replicate(1000, 1 + 2))
  rm(`+`)
  