// Szablon klasy SimpleVector.
#ifndef SIMPLEVECTOR_H
#define SIMPLEVECTOR_H
#include <iostream>
#include <new>         // Biblioteka wymagana przez wyjtek bad_alloc
#include <cstdlib>     // Biblioteka wymagana przez funkcj exit()
using namespace std;

template <class T>
class SimpleVector
{
private:
  T * aptr;          // Wskanik utworzonej tablicy
  int arraySize;     // Liczba elementw tablicy
  void memError();   // Funkcja obsugujca bdy przydzielenia pamici
  void subError();   // Funkcja obsugujca przekroczenie zakresu indeksw tablicy

public:
  // Domylny konstruktor
  SimpleVector()
    { aptr = 0; arraySize = 0; }

  // Deklaracja konstruktora
  SimpleVector(int);

  // Deklaracja konstruktora kopiujcego
  SimpleVector(const SimpleVector &);

  // Deklaracja destruktora
  ~SimpleVector();

  // Akcesor zwracajcy wielko tablicy
  int size() const
    { return arraySize; }

  // Akcesor zwracajcy wskazany element tablicy
  T getElementAt(int position);

  // Deklaracja przecionego operatora []
  T &operator[](const int &);
};

//************************************************************
// Konstruktor klasy SimpleVector. Okrela wielko tablicy
// i przydziela jej pami.
//************************************************************

template <class T>
SimpleVector<T>::SimpleVector(int s)
{
  arraySize = s;
  // Przydzielenie tablicy obszaru pamici
  try
  {
    aptr = new T[s];
  }
  catch (bad_alloc)
  {
    memError();
  }

  // Zainicjowanie tablicy
  for (int count = 0; count < arraySize; count++)
    *(aptr + count) = 0;
}

//*******************************************
// Konstruktor kopiujcy klasy SimpleVector
//*******************************************

template <class T>
SimpleVector<T>::SimpleVector(const SimpleVector &obj)
{
  // Skopiowanie wielkoci tablicy
  arraySize = obj.arraySize;

  // Przydzielenie tablicy obszaru pamici
  aptr = new T[arraySize];
  if (aptr == 0)
    memError();

  // Skopiowanie elementw tablicy obj
  for (int count = 0; count < arraySize; count++)
    *(aptr + count) = *(obj.aptr + count);
}

//**************************************
// Destruktor klasy SimpleVector
//**************************************

template <class T>
SimpleVector<T>::~SimpleVector()
{
  if (arraySize > 0)
    delete[] aptr;
}

//********************************************************
// Funkcja memError() wywietlajca komunikat o bdzie i przerywajca
// dziaanie programu w razie problemu z przydzieleniem pamici.
//********************************************************

template <class T>
void SimpleVector<T>::memError()
{
  cout << "Bd: nie mona przydzieli pamici.\n";
  exit(EXIT_FAILURE);
}

//************************************************************
// Funkcja subError() wywietlajca komunikat o bdzie i przerywajca
// dziaanie programu w razie przekroczenia zakresu tablicy
//************************************************************

template <class T>
void SimpleVector<T>::subError()
{
  cout << "Bd: indeks poza zakresem tablicy.\n";
  exit(EXIT_FAILURE);
}

//*******************************************************
// Funkcja getElementAt(). Argumentem jest indeks elementu.
// Funkcja zwraca warto zapisan
// w elemencie o podanym indeksie.
//*******************************************************

template <class T>
T SimpleVector<T>::getElementAt(int sub)
{
  if (sub < 0 || sub >= arraySize)
    subError();
  return aptr[sub];
}

//********************************************************
// Przeciony operator []. Argumentem jest indeks tablicy.
// Funkcja zwraca referencj do elementu tablicy
// o podanym indeksie.
//********************************************************

template <class T>
T &SimpleVector<T>::operator[](const int &sub)
{
  if (sub < 0 || sub >= arraySize)
    subError();
  return aptr[sub];
}
#endif
