﻿#ifndef DYNAMICQUEUE_H
#define DYNAMICQUEUE_H
#include <iostream>
using namespace std;

// Szablon klasy DynamicQueue
template <class T>
class DynamicQueue
{
private:
  // Struktura elementu kolejki
  struct QueueNode
  {
    T value;         // Wartość przechowywana w elemencie
    QueueNode *next; // Wskaźnik następnego elementu
  };

  QueueNode *front; // Wskaźnik początku kolejki
  QueueNode *rear;  // Wskaźnik końca kolejki
  int numItems;     // Liczba elementów kolejki
public:
  // Konstruktor
  DynamicQueue();

  // Destruktor
  ~DynamicQueue();

  // Operacje wykonywane na kolejce
  void enqueue(T);
  void dequeue(T &);
  bool isEmpty() const;
  bool isFull() const;
  void clear();
};

//********************************************
// Ten konstruktor tworzy pustą kolejkę
//********************************************
template <class T>
DynamicQueue<T>::DynamicQueue()
{
  front = nullptr;
  rear = nullptr;
  numItems = 0;
}

//********************************************
// Destruktor
//********************************************
template <class T>
DynamicQueue<T>::~DynamicQueue()
{
  clear();
}

//*********************************************
// Funkcja enqueue() umieszcza wartość argumentu item
// na końcu kolejki.
//*********************************************
template <class T>
void DynamicQueue<T>::enqueue(T item)
{
  QueueNode *newNode = nullptr;

  // Utworzenie nowego elementu i zapisanie w nim wartości argumentu item
  newNode = new QueueNode;
  newNode->value = item;
  newNode->next = nullptr;

  // Odpowiednia modyfikacja wskaźników początku i końca kolejki
  if (isEmpty())
  {
    front = newNode;
    rear = newNode;
  }
  else
  {
    rear->next = newNode;
    rear = newNode;
  }

  // Aktualizacja liczby elementów.
  numItems++;
}

//***********************************************
// Funkcja dequeue() usuwa element z początku kolejki
// i zapisuje go w argumencie item.
//***********************************************
template <class T>
void DynamicQueue<T>::dequeue(T &item)
{
  QueueNode *temp = nullptr;

  if (isEmpty())
  {
    cout << "Kolejka jest pusta.\n";
  }
  else
  {
    // Zapisanie w argumencie item wartości zawartej w pierwszym elemencie
    item = front->value;

    // Odłączenie pierwszego elementu od kolejki i usunięcie go
    temp = front;
    front = front->next;
    delete temp;

    // Aktualizacja liczby elementów
    numItems--;
  }
}

//**********************************************
// Funkcja isEmpty() zwraca wartość true, jeżeli kolejka jest pusta,
// lub false w przeciwnym razie
//**********************************************
template <class T>
bool DynamicQueue<T>::isEmpty() const
{
  bool status;

  if (numItems > 0)
    status = false;
  else
    status = true;
  return status;
}

//********************************************
// Funkcja clear() usuwa
// wszystkie elementy z kolejki.
//********************************************
template <class T>
void DynamicQueue<T>::clear()
{
  T value;  // Pomocnicza zmienna wykorzystywana do usuwania elementów

  while (!isEmpty())
    dequeue(value);
}
#endif
