﻿#ifndef DYNINTQUEUE_H
#define DYNINTQUEUE_H

class DynIntQueue
{
private:
  // Struktura elementu kolejki
  struct QueueNode
  {
    int value;        // Wartość przechowywana w elemencie
    QueueNode *next;  // Wskaźnik następnego elementu
  };

  QueueNode *front; // Wskaźnik początku kolejki
  QueueNode *rear;  // Wskaźnik końca kolejki
  int numItems;     // Liczba elementów kolejki
public:
  // Konstruktor
  DynIntQueue();

  // Destruktor
  ~DynIntQueue();

  // Operacje wykonywane na kolejce
  void enqueue(int);
  void dequeue(int &);
  bool isEmpty() const;
  bool isFull() const;
  void clear();
};
#endif
