// Plik implementacji klasy Player
#include "Player.h"
#include <cstdlib>
#include <ctime>
#include <string>
using namespace std;

//**********************************************
// Konstruktor
//**********************************************
Player::Player(string playerName)
{
  // Zainicjowanie generatora liczb losowych
  srand(time(0));

  name = playerName;
  guess = "";
  points = 0;
}

//***********************************************
// Funkcja makeGuess() generuje zakad gracza:
// "Cho (suma parzysta)" lub
// "Han (suma nieparzysta)".
//***********************************************
void Player::makeGuess()
{
  const int MIN_VALUE = 0;
  const int MAX_VALUE = 1;

  int guessNumber; // Zmienna przechowujca zakad gracza

  // Wygenerowanie liczby losowej 0 lub 1
  guessNumber = (rand() % (MAX_VALUE - MIN_VALUE + 1)) + MIN_VALUE;

  // Zamiana liczby na wynik Cho lub Han
  if (guessNumber == 0)
    guess = "Cho (suma parzysta)";
  else
    guess = "Han (suma nieparzysta)";
}

//***********************************************
// Funkcja addPoints() dodaje zadan
// liczb punktw do biecego
// konta gracza.
//***********************************************
void Player::addPoints(int newPoints)
{
  points += newPoints;
}

//***********************************************
// Funkcja getName() zwraca
// imi gracza.
//***********************************************
string Player::getName()
{
  return name;
}

//***********************************************
// Funkcja getGuess() zwraca
// zakad gracza.
//***********************************************
string Player::getGuess()
{
  return guess;
}

//**********************************************
// Funkcja getPoints() zwraca
// liczb punktw gracza.
//**********************************************
int Player::getPoints()
{
  return points;
}
