// Plik specyfikacji klasy Account
#ifndef ACCOUNT_H
#define ACCOUNT_H

class Account
{
private:
  double balance;      // Stan konta
  double interestRate; // Wysoko oprocentowania w biecym okresie
  double interest;     // Odsetki naliczone w biecym okresie
  int transactions;    // Liczba transakcji
public:
  Account(double iRate = 0.007, double bal = 0)
    { balance = bal;
      interestRate = iRate;
      interest = 0;
      transactions = 0; }

  void setInterestRate(double iRate)
    { interestRate = iRate; }

  void makeDeposit(double amount)
    {  balance += amount; transactions++; }

  bool withdraw(double amount); // Funkcja zdefiniowana w pliku Account.cpp

  void calcInterest()
    { interest = balance * interestRate; balance += interest; }

  double getInterestRate() const
    { return interestRate; }

  double getBalance() const
    { return balance; }

  double getInterest() const
    { return interest; }

  int getTransactions() const
    { return transactions; }
};
#endif
