// Ten program demonstruje uycie funkcji
// duplikujcej dowolnej wielkoci tablic typu int.
#include <iostream>
using namespace std;

// Prototyp funkcji
int *duplicateArray(const int *, int);
void displayArray(const int[], int);

int main()
{
  // Definicje staych oznaczajcych wielkoci tablic
  const int SIZE1 = 5, SIZE2 = 7, SIZE3 = 10;

  // Definicje trzech tablic o rnych wielkociach
  int array1[SIZE1] = { 100, 200, 300, 400, 500 };
  int array2[SIZE2] = { 10, 20, 30, 40, 50, 60, 70 };
  int array3[SIZE3] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 };

  // Definicje trzech wskanikw do nowych tablic
  int *dup1 = nullptr, *dup2 = nullptr, *dup3 = nullptr;

  // Powielenie tablic.
  dup1 = duplicateArray(array1, SIZE1);
  dup2 = duplicateArray(array2, SIZE2);
  dup3 = duplicateArray(array3, SIZE3);

  // Wywietlenie zawartoci oryginalnych tablic
  cout << "Zawarto oryginalnych tablic:\n";
  displayArray(array1, SIZE1);
  displayArray(array2, SIZE2);
  displayArray(array3, SIZE3);

  // Wywietlenie zawartoci nowych tablic
  cout << "\nZawarto nowych tablic:\n";
  displayArray(dup1, SIZE1);
  displayArray(dup2, SIZE2);
  displayArray(dup3, SIZE3);

  // Zwolnienie dynamicznie przydzielonej pamici
  // i przypisanie wskanikom wartoci 0
  delete[] dup1;
  delete[] dup2;
  delete[] dup3;
  dup1 = nullptr;
  dup2 = nullptr;
  dup3 = nullptr;
  return 0;
}
//******************************************************
// Funkcja duplicateArray(), ktrej argumentami s
// tablica typu int oraz liczba okrelajca wielko
// tablicy. Funkcja ta tworzy now tablic bdc kopi
// tablicy podanej w argumencie, a nastpnie zwraca
// wskanik z jej adresem. Jeeli argument zawiera bdn
// wielko, funkcja zwraca wskanik zerowy.
//******************************************************

int *duplicateArray(const int *arr, int size)
{
  int *newArray = nullptr;

  // Sprawdzenie wielkoci tablicy. Jeeli jest to liczba 0
  // lub liczba ujemna, funkcja zwraca wskanik zerowy.
  if (size <= 0)
    return nullptr;

  // Utworzenie nowej tablicy
  newArray = new int[size];

  // Skopiowanie danych do
  // nowej tablicy
  for (int index = 0; index < size; index++)
    newArray[index] = arr[index];

  // Zwrcenie wskanika do nowej tablicy
  return newArray;
}

//**************************************************
// Funkcja displayArray(), ktrej argumentami s tablica typu
// int oraz liczba okrelajca jej wielko. Funkcja wywietla
// zawarto podanej tablicy.
//**************************************************

void displayArray(const int arr[], int size)
{
  for (int index = 0; index < size; index++)
    cout << arr[index] << " ";
  cout << endl;
}
