// Ten program demonstruje uycie funkcji
// zwracajcej wskanik.
#include <iostream>
#include <cstdlib>  // Plik nagwkowy zawierajcy funkcje rand() i srand()
#include <ctime>    // Plik nagwkowy zawierajcy funkcj time()
using namespace std;

// Prototyp funkcji
int *getRandomNumbers(int);

int main()
{
  int *numbers = nullptr;  // Wskanik tablicy z liczbami

  // Utworzenie tablicy z picioma liczbami losowymi
  numbers = getRandomNumbers(5);

  // Wywietlenie liczb
  for (int count = 0; count < 5; count++)
    cout << numbers[count] << endl;

  // Zwolnienie pamici
  delete[] numbers;
  numbers = nullptr;
  return 0;
}

//***************************************************
// Funkcja getRandomNumbers() zwraca wskanik
// do tablicy zawierajcej liczby losowe. Argument 
// funkcji zawiera liczb elementw tablicy.
//***************************************************

int *getRandomNumbers(int num)
{
  int *arr = nullptr;  // Wskanik do tablicy z liczbami

  // Zwrcenie wskanika zerowego jeeli argument num zawiera zero lub liczb ujemn
  if (num <= 0)
    return nullptr;

  // Dynamiczne utworzenie tablicy
  arr = new int[num];

  // Zainicjowanie generatora liczb losowych poprzez wywoanie funkcji srand()
  // z argumentem zawierajcym wynik funkcji time()
  srand(time(0));

  // Wypenienie tablicy liczbami losowymi
  for (int count = 0; count < num; count++)
    arr[count] = rand();

  // Zwrcenie wskanika do tablicy
  return arr;
}
