// Plik specyfikacji klasy Student
#ifndef STUDENT_H
#define STUDENT_H
#include <string>
using namespace std;

class Student
{
protected:
  string name;       // Imi i nazwisko studenta
  string idNumber;   // Identyfikator studenta
  int yearAdmitted;  // Rok rozpoczcia studiw
public:
  // Domylny konstruktor
  Student()
    { name = "";
      idNumber = "";
      yearAdmitted = 0; }

  // Konstruktor
  Student(string n, string id, int year)
    { set(n, id, year); }

  // Funkcja set() zapisujca dane w zmiennych
  void set(string n, string id, int year)
    { name = n;               // Zapisanie imienia i nazwiska
      idNumber = id;          // Zapisanie identyfikatora
      yearAdmitted = year; }  // Zapisanie roku rozpoczcia studiw

  // Akcesory
  const string getName() const
    { return name; }

  const string getIdNum() const
    { return idNumber; }

  int getYearAdmitted() const
    { return yearAdmitted; }

  // Funkcja czysto wirtualna
  virtual int getRemainingHours() const = 0;
};
#endif
