// Plik specyfikacji klasy CsStudent.
#ifndef CSSTUDENT_H
#define CSSTUDENT_H
#include "Student.h"

// Stae zawierajce liczby wymaganych godzin rnych zaj
const int MATH_HOURS = 20;    // Matematyka
const int CS_HOURS = 40;      // Informatyka
const int GEN_ED_HOURS = 60;  // Przedmioty oglne

class CsStudent : public Student
{
private:
  int mathHours;   // Godziny odbytych zaj z matematyki
  int csHours;     // Godziny odbytych zaj z informatyki
  int genEdHours;  // Godziny odbytych zaj z przedmiotw oglnych

public:
  // Domylny konstruktor
  CsStudent() : Student()
    { mathHours = 0;
      csHours = 0;
      genEdHours = 0; }

  // Konstruktor
  CsStudent(string n, string id, int year) :
    Student(n, id, year)
    { mathHours = 0;
      csHours = 0;
      genEdHours = 0; }

  // Mutatory
  void setMathHours(int mh)
    { mathHours = mh; }

  void setCsHours(int csh)
    { csHours = csh; }

  void setGenEdHours(int geh)
    { genEdHours = geh; }

  // Nadpisana funkcja getRemainingHours()
  // Definicja znajduje si w pliku CsStudent.cpp.
  virtual int getRemainingHours() const;
};
#endif
