#ifndef STOCK_PURCHASE
#define STOCK_PURCHASE
#include "Stock.h"

class StockPurchase
{
private:
  Stock stock; // Obiekt reprezentujcy kupowan akcj
  int shares;  // Liczba akcji
public:
  // Domylny konstruktor przypisujcy zmiennej shares liczb 0
  // Obiekt stock jest inicjowany za pomoc jego domylnego konstruktora
  StockPurchase()
    { shares = 0; }

  // Konstruktor
  StockPurchase(const Stock &stockObject, int numShares)
    { stock = stockObject;
      shares = numShares; }

  // Akcesor
  double getCost() const
    { return shares * stock.getSharePrice(); }
};
#endif
