#ifndef PERSON_H
#define PERSON_H
#include <iostream>
#include <cstring>
using namespace std;

class Person
{
private:
  char *name;
public:
  // Domylny konstruktor
  Person()
  { cout << "*** domylny konstruktor ***\n";
    name = nullptr; }

  // Konstruktor z argumentem
  Person(char *n)
  { cout << "*** konstruktor z argumentem ***\n";
    name = new char[strlen(n) + 1];
    strcpy(name, n); }

  // Konstruktor kopiujcy
  Person(const Person &obj)
  { cout << "*** konstruktor kopiujcy ***\n";
    name = new char[strlen(obj.name) + 1];
    strcpy(name, obj.name); }

  // Destruktor
  ~Person()
  { cout << "*** destruktor ***\n";
    delete[] name; }

  // Przeciony operator =
  Person & operator=(const Person &right)
  { cout << "*** operator przypisania ***\n";
    if (this != &right)
    {
      if (name != nullptr)
        delete[] name;
      name = new char[strlen(right.name) + 1];
      strcpy(name, right.name);
    }
    return *this; }

  // Funkcja getName()
  char *getName() const
  { return name; }
};
#endif
