// Ten program tworzy raport sprzeday firmy Demetris S.A.
#include <iostream>
#include <iomanip>
using namespace std;

// Prototypy funkcji
void calcSales(const int[], const double[], double[], int);
void showOrder(const double[], const int[], int);
void dualSort(int[], double[], int);
void showTotals(const double[], const int[], int);
void swap(double&, double&);
void swap(int&, int&);

int main()
{
  // Staa NUM_PRODS zawierajca liczb oferowanych produktw
  const int NUM_PRODS = 9;

  // Tablica z identyfikatorami produktw
  int id[NUM_PRODS] = { 914, 915, 916, 917, 918,
                        919, 920, 921, 922 };

  // Tablica z liczbami sprzedanych sztuk kadego produktu
  int units[NUM_PRODS] = { 842, 416, 127, 514, 437,
                           269, 97,  492, 212 };

  // Tablica z cenami produktw
  double prices[NUM_PRODS] = { 51.95, 59.95, 75.95, 67.95, 87.95,
                               99.95, 59.95, 59.95, 67.95 };

  // Tablica zawierajca wyliczone wartoci sprzeday
  double sales[NUM_PRODS];

  // Wyliczenie wartoci sprzeday wszystkich produktw
  calcSales(units, prices, sales, NUM_PRODS);

  // Posortowanie elementw tablicy sales w kolejnoci malejcej
  // i przestawienie numerw liczbami w tablicy id tak, aby
  // obie tablice byy zsynchronizowane
  dualSort(id, sales, NUM_PRODS);

  // Ustawienie formatu wywietlania liczb
  cout << setprecision(2) << fixed << showpoint;

  // Wywietlenie numerw produktw i wielkoci ich sprzeday
  showOrder(sales, id, NUM_PRODS);

  // Wywietlenie cakowitej liczby sprzedanych produktw i cakowitej wielkoci sprzeday
  showTotals(sales, units, NUM_PRODS);
  return 0;
}

//****************************************************************
// Definicja funkcji calcSales(). Argumentami funkcji s tablice
// units, prices i sales oraz liczba cakowita num oznaczajca wielko 
// obu tablic. Funkcja wylicza wielko sprzeday kadego produktu,
// mnoc liczb sprzedanych sztuk przez jego cen. Wynik zapisuje
// w tablicy sales.
//****************************************************************

void calcSales(const int units[], const double prices[], double sales[], int num)
{
  for (int index = 0; index < num; index++)
    sales[index] = units[index] * prices[index];
}

//****************************************************************
// Definicja funkcji dualSort(). Argumentami funkcji s
// tablice id i sales oraz liczba cakowita size oznaczajca 
// wielko obu tablic. Funkcja sortuje malejco tablic 
// sales, wykorzystujc algorytm sortowania przez wybieranie.
// Elementy tablicy id zamienia w taki sam sposb jak
// elementy tablicy sales.
//****************************************************************

void dualSort(int id[], double sales[], int size)
{
  int start, maxIndex, tempid;
  double maxValue;

  for (start = 0; start < (size - 1); start++)
  {
    maxIndex = start;
    maxValue = sales[start];
    tempid = id[start];
    for (int index = start + 1; index < size; index++)
    {
      if (sales[index] > maxValue)
      {
        maxValue = sales[index];
        tempid = id[index];
        maxIndex = index;
      }
    }
    swap(sales[maxIndex], sales[start]);
    swap(id[maxIndex], id[start]);
  }
}

//******************************************************
// Funkcja swap() zamienia miejscami wartoci a i b typu double.
//******************************************************
void swap(double &a, double &b)
{
  double temp = a;
  a = b;
  b = temp;
}

//******************************************************
// Funkcja swap() zamienia miejscami wartoci a i b typu int.
//******************************************************
void swap(int &a, int &b)
{
  int temp = a;
  a = b;
  b = temp;
}

//*****************************************************************
// Definicja funkcji showOrder(). Argumentami funkcji s tablice
// sales i id oraz liczba cakowita num oznaczajca wielkoci obu
// tablic. Funkcja wywietla nagwek, a nastpnie posortowan 
// list numerw produktw i wielkoci ich sprzeday.
//*****************************************************************

void showOrder(const double sales[], const int id[], int num)
{
  cout << "Numer produktu\tWielko sprzeday\n";
  cout << "----------------------------------\n";
  for (int index = 0; index < num; index++)
  {
    cout << id[index] << "\t\t";
    cout << setw(8) << sales[index] << " z" << endl;
  }
  cout << endl;
}

//******************************************************************
// Definicja funkcji showTotals(). Argumentami funkcji s tablice
// sales i id oraz liczba cakowita num zawierajca wielkoci obu 
// tablic. Funkcja wylicza cakowit liczb sprzedanych produktw
// i cakowit wielko sprzeday, a nastpnie wywietla
// wyliczone wartoci.
//******************************************************************

void showTotals(const double sales[], const int units[], int num)
{
  int totalUnits = 0;
  double totalSales = 0.0;

  for (int index = 0; index < num; index++)
  {
    totalUnits += units[index];
    totalSales += sales[index];
  }
  cout << "Cakowita liczba sprzedanych sztuk: " << totalUnits << endl;
  cout << "Cakowita warto sprzeday: " << totalSales << " z" << endl;
}
