#include <stdio.h>

#define MAX 100

typedef int NODE;

typedef struct CELL *LIST;
struct CELL {
    NODE nodeName;
    LIST next;
};

enum MARKTYPE {VISITED, UNVISITED};

typedef struct {
    enum MARKTYPE mark;
    LIST successors;
} GRAPH[MAX];

void dfs(NODE u, GRAPH G)
{
    LIST p; /* lista ssiedztwa dla wierzchoka u */
    NODE v; /* wierzchoek w komrce wskazywanej przez p */

    G[u].mark = VISITED;
    p = G[u].successors;
    while (p != NULL) {
        v = p->nodeName;
        if (G[v].mark == UNVISITED)
            dfs(v, G);
        p = p->next;
    }
}
