#include <stdio.h>
#include <stdlib.h>

#define MAX 13

typedef int NODE;
typedef struct EDGE *EDGELIST;
struct EDGE {
    NODE node1, node2;
    EDGELIST next;
};
typedef struct TREENODE *TREE;
struct TREENODE {
    int height;
    TREE parent;
};

TREE find(NODE a, TREE nodes[]);
void merge(TREE x, TREE y);
EDGELIST makeEdges();

/* zwraca korze drzewa zawierajcego wierzchoek x, ktry
   odpowiada wierzchokowi a grafu */
TREE find(NODE a, TREE nodes[])
{
    TREE x;

    x = nodes[a];
    while (x->parent != NULL)
        x = x->parent;
    return x;
}

/* czy drzewa o korzeniach x oraz y w jedno drzewo poprzez uczynienie
    korzenia niszego drzewa potomkiem drzewa wyszego */
void merge(TREE x, TREE y)
{
    TREE higher, lower;

    if (x->height > y->height) {
        higher = x;
        lower = y;
    }
    else {
        higher = y;
        lower = x;
    }
    lower->parent = higher;
    if (lower->height == higher->height)
        ++(higher->height);
}

main()
{
    NODE u;
    TREE a, b;
    EDGELIST e;
    TREE nodes[MAX];

    /* inicjalizacja wierzchokw, tak aby kady z nich stanowi odrbne drzewo */
    for (u = 0; u < MAX; u++) {
        nodes[u] = (TREE) malloc(sizeof(struct TREENODE));
        nodes[u]->parent = NULL;
        nodes[u]->height = 0;
    }

    /* inicjalizacja e jako listy krawdzi grafu */
    e = makeEdges();

    /* sprawdzenie kadej krawdzi i jeli jej koce nale do rnych skadowych,
       poczenie tych skadowych */
    while (e != NULL) {
        a = find(e->node1, nodes);
        b = find(e->node2, nodes);
        if (a != b)
            merge(a, b);
        e = e->next;
    }
}
