#include <stdio.h>

#define MAX 100

typedef int NODE;

typedef struct CELL *LIST;
struct CELL {
    NODE nodeName;
    LIST next;
};

enum MARKTYPE {VISITED, UNVISITED};

typedef struct {
    enum MARKTYPE mark;
    LIST successors;
} GRAPH[MAX];

int k; /* zlicza odwiedzone wierzchoki */

void dfs(NODE u, GRAPH G)
{
    LIST p; /* wskanik do komrek listy ssiedztwa wierzchoka u */
    NODE v; /* wierzchoek w komrce, na ktr wskazuje p */

    G[u].mark = VISITED;
    p = G[u].successors;
    while (p != NULL) {
        v = p->nodeName;
        if (G[v].mark == UNVISITED)
            dfs(v, G);
        p = p->next;
    }
    ++k;
    G[u].postorder = k;
}

void dfsForest(GRAPH G)
{
    NODE u;

    k = 0;
    for (u = 0; u < MAX; u++)
    G[u].mark = UNVISITED;
    for (u = 0; u < MAX; u++)
        if (G[u].mark == UNVISITED)
            dfs(u, G);
}