﻿using static System.Console;

namespace Dzien07
{
    public class MemberVisibility
    {
        public void Display()
        {
            WriteLine("Widoczność składowych");
            // PrivateNProtectedMemberExample();
            // InternalMemberExample();
            PublicMemberExample();
            ReadLine();
        }

        private void PrivateNProtectedMemberExample()
        {
            new BaseClass.DeriveClass().Display();
        }

        private void InternalMemberExample()
        {
            var childClass = new Lib.ChildClass();
            WriteLine("Wywołanie z klasy pochodnej należącej do tego samego zestawu co klasa BaseClass.");
            childClass.Display();
        }

        private void PublicMemberExample()
        {
            ChildClassYounger childClassYounger = new ChildClassYounger();
            childClassYounger.Display();
        }


    }

    public class BaseClass
    {
        private const string AuthorName = "Jan Kowalski";
        protected const string EditorName = "Joanna Tkaczyk";

        public class DeriveClass : BaseClass
        {
            public void Display()
            {
                Write("Wartość odziedziczonej składowej prywatnej:");
                WriteLine($"{nameof(AuthorName)}'{AuthorName}'");
                ReadLine();
            }
        }
    }


    public class ChildClass : BaseClass
    {
        public void Display()
        {
            Write("Ta odziedziczona składowa prywatna nie jest tu dostępna:");
            // WriteLine($"{nameof(AuthorName)}'{AuthorName}'");

            Write("Składowa chroniona jest tu dostępna:");
            WriteLine($"{nameof(EditorName)} ma wartość '{EditorName}'");

            //BaseClass baseClass = new BaseClass();
            //Write("Ta składowa chroniona nie jest tu dostępna:");
            //WriteLine($"{nameof(baseClass.EditorName)}'{baseClass.EditorName}'");

            ReadLine();
        }
    }


    public class ChildClassofExternalBaseClass : Lib.BaseClass
    {
        public void Display()
        {
            Write("Ta składowa wewnętrzna klasy Lib.BaseClass nie jest tu widoczna:");
            // WriteLine($"{nameof(ReviewerName)} is '{ReviewerName}'");
        }
    }

    
    public class ChildClassYounger : ChildClass
    {
        private string _copyEditor = "Roman Piotrowski";

        public new void Display()
        {
            WriteLine($"Odwołanie w kodzie klasy ChildClassYounger: personalia to: '{_copyEditor}'");
            WriteLine("Wywołanie metody klasy ChildClass:");
            base.Display();
        }
    }
}