﻿using System;
using static System.Console;

namespace Dzien07
{
    public class EncapsulationImplementation
    {
        public void Display()
        {
            WriteLine("Przykład hermetyzacji.");
            Writer writer = new Writer();
            Write("Podaj imię autora: ");
            var fName = ReadLine();
            Write("Podaj nazwisko autora: ");
            var lName = ReadLine();
            writer.SetName(fName,lName);
            Write("Podaj tytuł książki: ");
            writer.SetTitle(ReadLine());
            Write("Podaj numer ISBN: ");
            writer.SetIsbn(ReadLine());
            WriteLine("Kompletne informacje o książce: ");
            WriteLine(writer.ToString());
        }

    }

    internal class Writer
    {
        private string _title;
        private string _isbn;
        private string _name;

        public void SetName(string fname, string lName)
        {
            if (string.IsNullOrEmpty(fname) || string.IsNullOrWhiteSpace(lName))
                throw new ArgumentException("Personalia nie mogą być pustym łańcuchem znaków.");

            _name = $"{fname} {lName}";
        }

        public void SetTitle(string title)
        {
            if (string.IsNullOrWhiteSpace(title))
                throw new ArgumentException("Tytuł książki nie może być pusty.");
            _title = title;
        }

        public void SetIsbn(string isbn)
        {
            if (!string.IsNullOrEmpty(isbn))
            {
                if (isbn.Length == 10 | isbn.Length == 13)
                {
                    if (!ulong.TryParse(isbn, out _))
                        throw new ArgumentException("Numer ISBN może zawierać wyłącznie cyfry.");
                }
                else
                    throw new ArgumentException("Numer ISBN może mieć 10 lub 13 znaków długości.");
            }
            _isbn = isbn;
        }

        public override string ToString() => $"Autor '{_name}' wydał książkę '{_title}' o numerze ISBN '{_isbn}'";
    }
}