﻿using static System.Console;
namespace Dzien07
{
    public class InheritanceImplementation
    {}

    public interface IBook
    {
        string Title { get; set; }
        string Isbn { get; set; }
        bool Ispublished { get; set; }
        void Detail();
    }
    public class Person
    {
        public string FirstName { get; set; } = "Jan";
        public string LastName { get; set; } = "Kowalski";
        public int Age { get; set; } = 43;
        public string Name => $"{FirstName} {LastName}";

        public virtual void Detail()
        {
            WriteLine("Szczegółowe informacje o osobie:");
            WriteLine($"Personalia: {Name}");
            WriteLine($"Age: {Age}");
            ReadLine();
        }
    }

    public class Author:Person, IBook
    {
        public string Title { get; set; }
        public string Isbn { get; set; }
        public bool Ispublished { get; set; }
        public override void Detail()
        {
            WriteLine("Szczegółowe informacje o autorze:");
            WriteLine($"Personalia: {Name}");
            WriteLine($"Wiek: {Age}");
            ReadLine();
        }
        void IBook.Detail()
        {
            WriteLine("Informacje o książce:");
            WriteLine($"Personalia autora: {Name}");
            WriteLine($"Wiek autora: {Age}");
            WriteLine($"Tytuł: {Title}");
            WriteLine($"Isbn: {Isbn}");
            WriteLine($"Opublikowano: {(Ispublished ? "Tak" : "Nie")}");
            ReadLine();
        }
    }

    public class Editor : Person
    {
        public override void Detail()
        {
            WriteLine("Informacje o redaktorze:");
            WriteLine($"Personalia: {Name}");
            WriteLine($"Wiek: {Age}");
            ReadLine();
        }
    }

    public class Reviewer : Person
    {
        public override void Detail()
        {
            WriteLine("Informacje o recenzencie:");
            WriteLine($"Personalia: {Name}");
            WriteLine($"Wiek: {Age}");
            ReadLine();
        }
    }
}