﻿using System;

using static System.Console;
using System.Linq;

using Dzien03Lib;
using System.Collections.Generic;

namespace Dzien03
{
    internal class Program
    {
        private static void Main(string[] args)
        {

            WriteLine( "" );
            //PressAnyKey();
            ValueTypeMenu();
        }

        private static void ValueTypeMenu()
        {
            int userInput;
            do
            {
                userInput = DisplayMenu();
                switch (userInput)
                {
                    case 1:
                        Clear();
                        Write("Wpisz liczbę: ");
                        var number = ReadLine();
                        var result = OddEven.FindOddEvenBySingleNumber(Convert.ToInt32(number));
                        WriteLine($"Liczba {result.Item1} jest {result.Item2}");
                        PressAnyKey();
                        break;
                    case 2:
                        Clear();
                        Write("Podaj pierszą liczbę zakresu: ");
                        var startNumber = ReadLine();
                        Write("Podaj ostatnią liczbę zakresu: ");
                        var lastNumber = ReadLine();
                        var results = OddEven.FindOddEvenWithinRange(Convert.ToInt32(startNumber),
                            Convert.ToInt32(lastNumber));
                        foreach (var tuple in results)
                            WriteLine($"Liczba {tuple.Item1} jest {tuple.Item2}");

                        PressAnyKey();
                        break;
                    case 3:
                        Clear();
                        Write("Wpisz sekwencję liczb (rozdzielonych przecinkiem): ");
                        var numberSeries = ReadLine();

                        if (numberSeries != null)
                        {
                            var resultSeries =
                                OddEven.FindOddEvenBySeries(numberSeries.Split(',').Select(int.Parse).ToList());
                            foreach (var tuple in resultSeries)
                                WriteLine($"Liczba {tuple.Item1} jest {tuple.Item2}");
                        }
                        PressAnyKey();
                        break;
                    case 4:
                        Clear();
                        Write("Wpisz pierwszą liczbę: ");
                        var userInputFirst = ReadLine();
                        Write("Wpisz drugą liczbę: ");
                        var userInputSecond = ReadLine();
                        var noNamed = OddEven.FindOddEvenBySingleNumber(Convert.ToInt32(userInputFirst));
                        var named = OddEven.FindOddEvenBySingleNumberNamedElement(Convert.ToInt32(userInputSecond));
                        WriteLine($"Pierwsza liczba {noNamed.Item1} jest {noNamed.Item2} - użycie krotek bez nazw.");
                        WriteLine($"Druga liczba {named.number} jest {named.oddOrEven} - użycie krotek z nazwanymi elementami.");

                        WriteLine("Przypisanie krotki z nazwami do krotki bez nazwanych elementów.");
                        noNamed = named;
                        WriteLine($"Liczba {noNamed.Item1} jest {named.Item2} - po przypisaniu.");
                        Write("Wpisz trzecią liczbę: ");
                        var userInputThird = ReadLine();
                        var noNamed2 = OddEven.FindOddEvenBySingleNumber(Convert.ToInt32(userInputThird));
                        WriteLine(
                            $"Trzecia liczba {noNamed2.Item1} jest {noNamed2.Item2} - użycie drugiej krotki bez nazwanych elementów.");
                        WriteLine("Przypisanie drugiej krotki bez nazwanych elementów do krotki z nazwanymi elementami.");
                        named = noNamed2;
                        WriteLine($"Druga liczba {named.number} jest {named.oddOrEven} - po przypisaniu.");
                        PressAnyKey();
                        break;
                    case 5:
                        Clear();
                        Write("Enter number: ");
                        var numberInt = ReadLine();
                        var resultBefore = OddEven.FindOddEvenBySingleNumberNamedElement(Convert.ToInt32(numberInt));
                        WriteLine(
                            $"Number:{resultBefore.number} is {resultBefore.oddOrEven} is before conversion.");
                        PressAnyKey();
                        break;
                    case 6:
                        Clear();
                        Write("Wpisz liczbę: ");
                        var num = ReadLine();
                        var resultNum = OddEven.FindOddEvenBySingleNumberNamedElement(Convert.ToInt32(num));
                        WriteLine($"Liczba {resultNum.number} jest {resultNum.oddOrEven}.");
                        WriteLine();
                        var comp = OddEven.CompareToTuple(Convert.ToInt32(num));
                        WriteLine($"Porównanie dwóch obiektów Tuple mających różne elementy value zwróciło: {comp}");
                        var comp1 = OddEven.CompareToTuple1(Convert.ToInt32(num));
                        WriteLine($"Porównanie dwóch obiektów Tuple mających ten sam element value zwróciło: {comp1}");
                        PressAnyKey();
                        break;
                    case 7:
                        Clear();
                        Write("Wpisz liczbę: ");
                        var num1 = ReadLine();
                        var namedElement = OddEven.FindOddEvenBySingleNumberNamedElement(Convert.ToInt32(num1));
                        WriteLine($"Liczba {namedElement.number} jest {namedElement.oddOrEven}.");
                        WriteLine();
                        var equalToTuple = OddEven.EqualToTuple(Convert.ToInt32(num1));
                        WriteLine($"Wynik sprawdzenia równości dwóch obiektów Tuple: {equalToTuple}");
                        var equalToObject = OddEven.EqualToObject(Convert.ToInt32(num1));
                        WriteLine($"Wynik sprawdzenia równości obiektu Tuple oraz krotki, która nie jest obiektem Tuple: {equalToObject}");
                        PressAnyKey();
                        break;
                    case 8:
                        Clear();
                        WriteLine("Nowe możliwości C# 7.1: domyślny literał");
                        int thisIsANewDefault = default;
                        int thisIsAnOlderDefault = default;
                        var thisIsAnOlderDefaultAndValid = default(int);
                        //var thisIsNotValid = default; // nieprawidłowe, nie można przypisywać default do zmiennej, której typ nie został określony jawnie
                        const int thisIsANewDefaultConst = default; // prawidłowe
                        const int thisIsAnOlderDefaultConst = default; // prawidłowe 
                        //const int? thisIsInvalid = default; // nieprawidłowe, nie można używać default w deklaracji stałej, której typ nie został określony jawnie

                        WriteLine($"Nowy literał domyślny:{thisIsANewDefault}. Stary literał domyślny:{thisIsAnOlderDefault}");
                        PressAnyKey();
                        break;
                    case 9:
                        Clear();
                        WriteLine("Możliwości C# 7.1: Wnioskowanie nazw krotek");
                        Write("Podaj pierwszą liczbę:");
                        var number1 = ReadLine();
                        Write("Podaj drugą lizcbę:");
                        var number2 = ReadLine();
                        OddEven.InferTupleNames(Convert.ToInt32(number1), Convert.ToInt32(number2));
                        PressAnyKey();
                        break;
                }
            } while (userInput != 10);
        }

        private static void PressAnyKey()
        {
            Write("Press any key...");
            ReadLine();
            Clear();
        }

        private static int DisplayMenu()
        {
            return Convert.ToInt32(SelectedMenu());
        }


        private static int SelectedMenu()
        {
            WriteLine("Nauka C# w 7 dni - Przykłady - Dzień 3.");
            WriteLine();
            WriteLine("1. Parzysty/nieparzysty dla jednej wartości");
            WriteLine("2. Parzysty/nieparzysty dla zakresu");
            WriteLine("3. Parzysty/nieparzysty dla serii");
            WriteLine("4. Przypisania");
            WriteLine("5. Niejawne rzutowania");
            WriteLine("6. Porównanie");
            WriteLine("7. Równość");
            WriteLine("8. Wyrażenia domyślnej (C# 7.1)");
            WriteLine("9. Wnioskowanie nazw krotek (C# 7.1)");
            WriteLine("10. Koniec");
            Write("Podaj opcję (1-10): ");
            var result = ReadLine();
            return string.IsNullOrEmpty(result) ? 0 : Convert.ToInt32(result);
        }
    }
}