﻿using System;
using static System.Console;

namespace Dzien02
{
    public class CSharpOperator
    {
        public int Num1 { get; set; }
        public int Num2 { get; set; }
        public int Num3 { get; set; }
        public int Num4 { get; set; }


        public void Display()
        {
            WriteLine($"{nameof(Num1)}={Num1}");
            WriteLine($"{nameof(Num2)}={Num2}");
            WriteLine();
            ArithmeticOperators();
            RelationalOperators();
            LogicalOperators();
            BitwiseOperators();
            AssignmentOperators();
            OperatorPrecedence();
        }

       private void ArithmeticOperators()
        {
            WriteLine("\nOperatory arytmetyczne\n");
            WriteLine($"Operator '+' (dodawanie): {nameof(Num1)} + {nameof(Num2)} = {Num1 + Num2}");
            WriteLine($"Operator '-' (odejmowanie): {nameof(Num1)} - {nameof(Num2)} = {Num1 - Num2}");
            WriteLine($"Operator '*' (mnożenie): {nameof(Num1)} * {nameof(Num2)} = {Num1 * Num2}");
            WriteLine($"Operator '/' (dzielenie): {nameof(Num1)} / {nameof(Num2)} = {Num1 / Num2}");
            WriteLine($"Operator '%' (reszta z dzielenia): {nameof(Num1)} % {nameof(Num2)} = {Num1 % Num2}");
            WriteLine($"Operator '++' (inkrementacja): preinkrementacja: ++{nameof(Num1)} = {++Num1}");
            WriteLine($"Operator '++' (inkrementacja): postinkrementacja: {nameof(Num1)}++ = {Num1++}");
            WriteLine($"Operator '--' (dekrementacja): predekrementacja: --{nameof(Num2)} = {--Num2}");
            WriteLine($"Operator '--' (dekrementacja): postdekrementacja: {nameof(Num2)}-- = {Num2--}");
            ReadLine();
        }

        private void RelationalOperators()
        {
            WriteLine("\nOperatory porównania\n");
            WriteLine($"Operator '==' (równy): {nameof(Num1)} == {nameof(Num2)} = {Num1 == Num2}");
            WriteLine($"Operator '!=' (różny): {nameof(Num1)} != {nameof(Num2)} = {Num1 != Num2}");
            WriteLine($"Operator '>' (większy): {nameof(Num1)} > {nameof(Num2)} = {Num1 > Num2}");
            WriteLine($"Operator '<' (mniejszy): {nameof(Num1)} < {nameof(Num2)} = {Num1 < Num2}");
            WriteLine($"Operator '>=' (większy lub równy): {nameof(Num1)} >= {nameof(Num2)} = {Num1 >= Num2}");
            WriteLine($"Operator '<=' (mniejszy lub równy): {nameof(Num1)} <= {nameof(Num2)} = {Num1 <= Num2}");
            ReadLine();
        }

        private void LogicalOperators()
        {
            WriteLine("\nOperatory logiczne\n");
            var bln1 = Num1 == Num2;
            var bln2 = Num1 >= Num2;
            WriteLine($"{nameof(bln1)} = {bln1}");
            WriteLine($"{nameof(bln2)} = {bln2}");
            WriteLine();
            WriteLine($"Operator '&&' (AND): {nameof(bln1)} && {nameof(bln2)} = {bln1 && bln2}");
            WriteLine($"Operator '||' (OR): {nameof(bln1)} || {nameof(bln2)} = {bln1 || bln2}");
            WriteLine($"Operator '!' (NOT): {nameof(bln1)} ! {nameof(bln2)} = {!(bln1 && bln2)}");


            ReadLine();
        }

        private void BitwiseOperators()
        {
            WriteLine("\nOperatory bitowe\n");
            var bln1 = ConvertToBinaryEightBits(Num1); //8-bit
            var bln2 = ConvertToBinaryEightBits(Num2); //8-bit
            WriteLine($"W zapisie dwójkowym {Num1} = {bln1}");
            WriteLine($"W zapisie dwójkowym {Num2} = {bln2}");
            WriteLine();
            WriteLine($"Operator '|' (OR): {nameof(Num1)} | {nameof(Num2)} = {Num1 | Num2}");
            WriteLine($"W zapisie dwójkowym: {bln1} | {bln2} = {ConvertToBinaryEightBits(Num1 | Num2)}");
            WriteLine($"Operator '&' (AND): {nameof(Num1)} & {nameof(Num2)} = {Num1 & Num2}");
            WriteLine($"W zapisie dwójkowym: {bln1} & {bln2} = {ConvertToBinaryEightBits(Num1 & Num2)}");
            WriteLine($"Operator '^' (XOR): {nameof(Num1)} ^ {nameof(Num2)} = {Num1 ^ Num2}");
            WriteLine($"W zapisie dwójkowym: {bln1} ^ {bln2} = {ConvertToBinaryEightBits(Num1 ^ Num2)}");
            WriteLine($"Operator '~' (dopełnienie): ~{nameof(Num1)} = {~Num1}");
            WriteLine($"W zapisie dwójkowym: ~{bln1} = {ConvertToBinaryEightBits(~Num1)}");
            WriteLine($"Operator '~' (dopełnienie): ~{nameof(Num2)} = {~Num2}");
            WriteLine($"W zapisie dwójkowym: ~{bln2} = {ConvertToBinaryEightBits(~Num2)}");
            WriteLine($"Operator '<<' (przesunięcie w lewo): {nameof(Num1)}<<1 = {Num1 << 1}");
            WriteLine($"W zapisie dwójkowym: {bln1}<<1 = {ConvertToBinaryEightBits(Num1 << 1)}");
            WriteLine($"Operator '>>' (przesunięcie w prawo): {nameof(Num1)}>>1 = {Num1 >> 1}");
            WriteLine($"W zapisie dwójkowym: {bln1}>>1 = {ConvertToBinaryEightBits(Num1 >> 1)}");

            ReadLine();
        }

        private void AssignmentOperators()
        {
            var result = 0;
            WriteLine("\nOperatory przypisania\n");
            WriteLine($"Operator '=' (przypisanie): {nameof(result)}={nameof(Num1)} + {nameof(Num2)} gdzie {nameof(result)} zawiera wartość: {Num1+Num2}");
            WriteLine($"Operator '+=' (dodanie i przypisanie): {nameof(result)}+={nameof(Num1)}  gdzie {nameof(result)} zawiera wartość: {result+=Num1}");
            WriteLine($"Operator '-=' (odjęcie i przypisanie): {nameof(result)}-={nameof(Num1)}  gdzie {nameof(result)} zawiera wartość: {result -= Num1}");
            WriteLine($"Operator '*=' (pomnożenie i przypisanie): {nameof(result)}*={nameof(Num1)}  gdzie {nameof(result)} zawiera wartość: {result *= Num1}");
            WriteLine($"Operator '/=' (podzielenie i przypisanie): {nameof(result)}/={nameof(Num1)}  gdzie {nameof(result)} zawiera wartość: {result /= Num1}");
            WriteLine($"Operator '%=' (reszta z dzielenia i przypisanie): {nameof(result)}%={nameof(Num1)}  gdzie {nameof(result)} zawiera wartość: {result %= Num1}");

            ReadLine();
        }

        private void OperatorPrecedence()
        {
            Write("Podaj pierwszą liczbę:");
            Num1 = Convert.ToInt32(ReadLine());
            Write("Podaj drugą liczbę:");
            Num2 = Convert.ToInt32(ReadLine());
            Write("Podaj trzecią liczbę:");
            Num3 = Convert.ToInt32(ReadLine());
            Write("Podaj czwartą liczbę:");
            Num4 = Convert.ToInt32(ReadLine());
            int result = Num1 + Num2 * Num3/Num4;
            WriteLine($"Num1 + Num2 * Num3/Num4 = {result}");
            result = Num1 + Num2 * (Num3 / Num4);
            WriteLine($"Num1 + Num2 * (Num3/Num4) = {result}");
            result = (Num1 + (Num2 * Num3)) / Num4;
            WriteLine($"(Num1 + (Num2 * Num3)) /Num4 = {result}");
            result = (Num1 + Num2) * Num3 / Num4;
            WriteLine($"(Num1 + Num2) * Num3/Num4 = {result}");
            ReadLine();
        }

        private string ConvertToBinaryEightBits(int number) => Convert.ToString(number, 2).PadLeft(8,'0');
    }

    public struct Coordinate
    {
        public bool Equals(Coordinate other) => _xAxis == other._xAxis && _yAxis == other._yAxis;

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj)) return false;
            return obj is Coordinate && Equals((Coordinate) obj);
        }

        public override int GetHashCode()
        {
            unchecked
            {
                return (_xAxis * 397) ^ _yAxis;
            }
        }

        private readonly int _xAxis;
        private readonly int _yAxis;
        public Coordinate(int xAxis, int yAxis)
        {
            _xAxis = xAxis;
            _yAxis = yAxis;
        }

        public static Coordinate operator +(Coordinate coordinate1, Coordinate coordinate2) =>
            new Coordinate(coordinate1._xAxis + coordinate2._xAxis, coordinate1._yAxis + coordinate2._yAxis);
        public static Coordinate operator-(Coordinate coordinate1, Coordinate coordinate2) =>
            new Coordinate(coordinate1._xAxis - coordinate2._xAxis, coordinate1._yAxis - coordinate2._yAxis);
        public static Coordinate operator *(Coordinate coordinate1, Coordinate coordinate2) =>
            new Coordinate(coordinate1._xAxis * coordinate2._xAxis, coordinate1._yAxis * coordinate2._yAxis);
        public static Coordinate operator /(Coordinate coordinate1, Coordinate coordinate2) =>
            new Coordinate(coordinate1._xAxis / coordinate2._xAxis, coordinate1._yAxis / coordinate2._yAxis);
        public static Coordinate operator %(Coordinate coordinate1, Coordinate coordinate2) =>
            new Coordinate(coordinate1._xAxis % coordinate2._xAxis, coordinate1._yAxis % coordinate2._yAxis);

        public static bool operator ==(Coordinate coordinate1, Coordinate coordinate2) =>
            coordinate1._xAxis == coordinate2._xAxis && coordinate1._yAxis == coordinate2._yAxis;

        public static bool operator !=(Coordinate coordinate1, Coordinate coordinate2) => !(coordinate1 == coordinate2);

        public static bool operator <(Coordinate coordinate1, Coordinate coordinate2) =>
            coordinate1._xAxis < coordinate2._xAxis && coordinate1._yAxis < coordinate2._yAxis;

        public static bool operator >(Coordinate coordinate1, Coordinate coordinate2) =>
            coordinate1._xAxis > coordinate2._xAxis && coordinate1._yAxis > coordinate2._yAxis;

        public static bool operator <=(Coordinate coordinate1, Coordinate coordinate2) =>
            coordinate1._xAxis <= coordinate2._xAxis && coordinate1._yAxis <= coordinate2._yAxis;

        public static bool operator >=(Coordinate coordinate1, Coordinate coordinate2) =>
            coordinate1._xAxis >= coordinate2._xAxis && coordinate1._yAxis >= coordinate2._yAxis;

        public double Area() => _xAxis * _yAxis;

        public override string ToString() => $"({_xAxis},{_yAxis})";
    }
}