﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using static System.Console;
using static System.Convert;

namespace Dzien06
{

    internal class Program
    {



        private static void Main(string[] args)
        {

            int userInput;
            do
            {
                userInput = DisplayMenu();
                switch (userInput)
                {
                    case 1:
                        Clear();
                        PersonList();
                        PressAnyKey();
                        break;
                    case 2:
                        Clear();
                        NonGenericListWithAuthorNameAndAge();
                        PressAnyKey();
                        break;
                    case 3:
                        Clear();
                        ImplementValueTypeGenericClass();
                        PressAnyKey();
                        break;
                    case 4:
                        Clear();
                        ImplementReferenceTypeGenericClass();
                        PressAnyKey();
                        break;
                    case 5:
                        Clear();
                        ImplementDefaultConstructorGenericClass();
                        PressAnyKey();
                        break;
                    case 6:
                        Clear();
                        ImplementInterfaceConstraint();
                        PressAnyKey();
                        break;
                    case 7:
                        Clear();
                        TestCustomAttribute();
                        PressAnyKey();
                        break;
                    case 8:
                        Clear();
                        TestPreprocessorDirective();
                        PressAnyKey();
                        break;
                    case 9:
                        Clear();
                        TestLinq();
                        PressAnyKey();
                        break;
                    case 10:
                        Clear();
                        TestUnsafeSwap();
                        PressAnyKey();
                        break;
                    case 11:
                        Clear();
                        BitArrayBoolArrayPerformance();
                        PressAnyKey();
                        break;

                }
            } while (userInput != 12);
        }

        private static void BitArrayBoolArrayPerformance()
        {
            // To prosty test;
            // nie sprawdza wydajności działania operacji takich jak przesunięcia bitowe.
            WriteLine("Porównanie wydajności BitArray oraz bool[].\n");
            WriteLine($"Całkowita liczba elementów: {int.MaxValue}");
            PressAnyKey();
            WriteLine("Testowanie kolekcji BitArray:");
            var bitArrayTestResult = BitArrayTest(int.MaxValue);
            WriteLine("Test zakończony.");
            WriteLine("Czas: {0:hh\\:mm\\:ss} ",  TimeSpan.FromMilliseconds(bitArrayTestResult));

            WriteLine("\nTestowanie tablicy bool[]:");
            WriteLine($"Całkowita liczba elementów: {int.MaxValue}");
            PressAnyKey();
            var boolArrayTestResult = BoolArrayTest(int.MaxValue);
            WriteLine("Test zakończony.");
            WriteLine("Czas: {0:hh\\:mm\\:ss} ", TimeSpan.FromMilliseconds(boolArrayTestResult));
        }

        private static long BitArrayTest(int max)
        {
            Stopwatch stopwatch = Stopwatch.StartNew();
            var bitarray = new BitArray(max);
            for (int index = 0; index < bitarray.Length; index++)
            {
                bitarray[index] = !bitarray[index];
                WriteLine($"'bitarray[{index}]' = {bitarray[index]}");
            }
            stopwatch.Stop();
            return stopwatch.ElapsedMilliseconds;
        }
        private static long BoolArrayTest(int max)
        {
            Stopwatch stopwatch = Stopwatch.StartNew();
            var boolArray = new bool[max];
            for (int index = 0; index < boolArray.Length; index++)
            {
                boolArray[index] = !boolArray[index];
                WriteLine($"'boolArray[{index}]' = {boolArray[index]}");
            }
            stopwatch.Stop();
            return stopwatch.ElapsedMilliseconds;
        }

        private static void PressAnyKey()
        {
            Write("\nNaciśnij dowolny klawisz...");
            ReadLine();
            Clear();
        }

        private static int DisplayMenu()
        {
            return ToInt32(SelectedMenu());
        }

        private static int SelectedMenu()
        {
            WriteLine("Nauka C# w 7 dni - Przykłady - Dzień 6.");
            WriteLine();
            WriteLine("1. Lista obiektów Person.");
            WriteLine("2. Nieogólna lista zawierająca personalia i wiek.");
            WriteLine("3. Klasa ogólna z typem wartościowym.");
            WriteLine("4. Klasa ogólna z typem referencyjnym.");
            WriteLine("5. Klasa ogólna z ograniczeniem konstruktora domyślnego.");
            WriteLine("6. Stosowanie ograniczeń interfejsów.");
            WriteLine("7. Test niestandardowych atrybutów.");
            WriteLine("8. Test dyrektyw preprocesora.");
            WriteLine("9. Test LINQ.");
            WriteLine("10. Test niebezpiecznego kodu.");
            WriteLine("11. Porównanie wydajności BitArray oraz tabliby bool[].");
            WriteLine("12. Koniec");
            Write("Wpisz number (1-12): ");
            var result = ReadLine();
            return string.IsNullOrEmpty(result) ? 0 : ToInt32(result);
        }

        private static unsafe void TestUnsafeSwap()
        {
            Write("Podaj pierwszą liczbę: ");
            var num1 = Convert.ToInt32(ReadLine());
            Write("Podaj drugą liczbę: ");
            var num2 = Convert.ToInt32(ReadLine());
            WriteLine("Liczby przed wykonaniem zamiany:");
            WriteLine($"Liczba1:{num1}, Liczba2:{num2}");
            // Wywołanie funkcji zamieniającej liczby
            new UnsafeSwap().SwapNumbers(&num1, &num2);
            WriteLine("Liczby po wykonaniu zamiany:");
            WriteLine($"Liczba1:{num1}, Liczba2:{num2}");
        }
        //*/

        private static void TestLinq()
        {
            var person = from p in Person.GetPersonList()
                         where p.Id == 1
                         select p;
            foreach (var per in person)
            {
                WriteLine($"Id osoby:{per.Id}");
                WriteLine($"Personalia:{per.FirstName} {per.LastName}");
                WriteLine($"Wiek:{per.Age}");
            }
        }

        private static void TestPreprocessorDirective()
        {
            var precessor = new PreprocessorDirective();
            precessor.ConditionalProcessor();
            precessor.LinePreprocessor();
            precessor.WarningPreProcessor();
        }

        private static void TestCustomAttribute()
        {
            Write("Wpisz liczbę 1.:");
            var num1 = ReadLine();
            Write("Wpisz liczbę 2.:");
            var num2 = ReadLine();

            WriteLine(new MathClass().Add(Convert.ToInt32(num1), Convert.ToInt32(num2)));
        }

        private static void NonGenericListWithAuthorNameAndAge()
        {
            // nie jest zgłaszany żaden wyjątek, ani podczas kompilacji, ani podczas wykonywania kodu
            ArrayList authorArrayList = new ArrayList { "Jan Kowalski", "43" };
            foreach (string author in authorArrayList)
                WriteLine($"{author}");

            // brak wyjątku podczas kompilacji - jest natomiast zgłaszany podczas wykonywania kodu
            ArrayList editorArrayList = new ArrayList { "Joanna Tkaczyk", 25 }; // zgłasza wyjątek podczas wykonywania kodu
            foreach (int editor in editorArrayList)
                WriteLine($"{editor}");


            // żaden wyjątek nie jest zgłaszany - ani podczas kompilacji, ani podczas wykonywania kodu.
            var authorEditorArrayList = new ArrayList { "Jan Kowalski", 43, "Joanna Tkaczyk", 25 };
            foreach (var authorEditor in authorEditorArrayList)
                WriteLine($"{authorEditor}");
        }


        private static void PersonList()
        {
            WriteLine("Lista osób:");
            foreach (var person in Person.GetPersonList())
            {
                WriteLine($"Personalia:{person.FirstName} {person.LastName}");
                WriteLine($"Wiek:{person.Age}");
            }
        }

        private static void ImplementReferenceTypeGenericClass()
        {
            const string thisIsAuthorName = "Jan Kowalski";
            var referenceTypeConstraint = new ReferenceTypeConstraint<string>();
            WriteLine($"Name:{referenceTypeConstraint.ImplementIt(thisIsAuthorName)}");

            var referenceTypePersonConstraint = new ReferenceTypeConstraint<Person>();


            var person = referenceTypePersonConstraint.ImplementIt(new Person
            {
                FirstName = "Jan",
                LastName = "Kowalski",
                Age = 43
            });
            WriteLine($"Personalia:{person.FirstName}{person.LastName}");
            WriteLine($"Wiek:{person.Age}");
        }

        private static void ImplementValueTypeGenericClass()
        {
            const int age = 43;
            var valueTypeConstraint = new ValueTypeConstraint<int>();
            WriteLine($"Wiek:{valueTypeConstraint.ImplementIt(age)}");
        }

        private static void ImplementDefaultConstructorGenericClass()
        {
            var constructorConstraint = new DefaultConstructorConstraint<ClassWithDefaultConstructor>();
            var result = constructorConstraint.ImplementIt(new ClassWithDefaultConstructor { Name = "Jan Kowalski" });
            WriteLine($"Personalia:{result.Name}");
        }

        private static void ImplementBaseClassConstraint()
        {
            BaseClassConstraint<Author> baseClassConstraint = new BaseClassConstraint<Author>();
            var result = baseClassConstraint.ImplementIt(new Author
            {
                FirstName = "Szymon",
                LastName = "Wolański",
                Age = 40
            });

            WriteLine($"Personalia: {result.FirstName} {result.LastName}");
            WriteLine($"Wiek: {result.Age}");
        }

        private static void ImplementInterfaceConstraint()
        {
            var entityConstraint = new InterfaceConstraint<EntityClass>();
            var result = entityConstraint.ImplementIt(new EntityClass { Name = "Jan Kowalski" });
            WriteLine($"Imię:{result.Name}");
        }

        //[PeerInformation("Zakończono poziom 1.")]
        private void PeerOperation()
        {
            // inny kod
        }
    }

    // [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method)]
    [AttributeUsage(AttributeTargets.Class)]
    public class PeerInformationAttribute : Attribute
    {
        public PeerInformationAttribute(string information)
        {
            WriteLine(information);
        }
    }
}