﻿using System;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using static System.Console;
using static System.Convert;

namespace Dzien04
{
    internal class Program
    {
        private static void Main(string[] args)
        {
            int userInput;
            do
            {
                userInput = DisplayMenu();
                switch (userInput)
                {
                    case 1:
                        Clear();
                        CallStringCalculatorUpdated();
                        PressAnyKey();
                        break;
                    case 2:
                        Clear();
                        ExceptionExample();
                        PressAnyKey();
                        break;
                    case 3:
                        Clear();
                        FileInputOutputOperation();
                        PressAnyKey();
                        break;
                    case 4:
                        Clear();
                        RegularExpressionExample();
                        PressAnyKey();
                        break;
                    case 5:
                        Clear();
                        IndexerExample();
                        PressAnyKey();
                        break;
                }
            } while (userInput != 6);

        }
        private static void PressAnyKey()
        {
            Write("Naciśnij dowolny klawisz...");
            ReadLine();
            Clear();
        }

        private static int DisplayMenu()
        {
            return ToInt32(SelectedMenu());
        }


        private static int SelectedMenu()
        {
            WriteLine("Nauka C# w 7 dni - Przykłady - Dzień 4.");
            WriteLine();
            WriteLine("1. Wywołanie StringCalculatorUpdated");
            WriteLine("2. Przykład wyjątku.");
            WriteLine("3. Operacje wejścia-wyjścia na plikach.");
            WriteLine("4. Przykład wyrażeń regularnych.");
            WriteLine("5. Przykład indeksera.");
            WriteLine("6. Koniec");
            Write("Wybierz opcję (1-6): ");
            var result = ReadLine();
            return string.IsNullOrEmpty(result) ? 0 : ToInt32(result);
        }


        private static void IndexerExample()
        {
            WriteLine("Przykład indeksera");
            Write("Podaj imię osoby do wyszukania w kolekcji:");
            var name = ReadLine();
            var person = new PersonCollection();
            var result = person[name] ? "istnieje" : "nie istnieje";
            WriteLine($"Osoba o imieniu {name} {result}.");
        }

        private static void RegularExpressionExample()
        {
            WriteLine("Przykład wyrażeń regularnych.\n");
            Write("Wpisz tekst do dopasowania:");
            var inputText = ReadLine();
            if (string.IsNullOrEmpty(inputText))
                inputText = @"Szybki brązowy lis przeskoczył nad leniwym psem.";
            WriteLine("Oto wyniki dopasowania z użyciem różnych wyrażeń regularnych:\n");
            const string theDot = @"\.";
            WriteLine("Znak kropki [.]");
            ValidateInputText(inputText, theDot, true);
            const string theword = @"\w";
            WriteLine("Litery występujące w słowach [w]");
            ValidateInputText(inputText, theword, true);
            const string theSpace = @"\s";
            WriteLine("Znak odstępu [s]");
            ValidateInputText(inputText, theSpace, true);
            const string theSquareBracket = @"\[The]";
            WriteLine("Nawiasy kwadratowe [( )]");
            ValidateInputText(inputText, theSquareBracket, true);
            const string theHyphen = @"\[a-z0-9]ww";
            WriteLine("Znak zakresu [-]");
            ValidateInputText(inputText, theHyphen, true);
            const string theStar = @"\[a*]";
            WriteLine("Znak gwiazdki [*] ");
            ValidateInputText(inputText, theStar, true);
            const string thePlus = @"\[a+]";
            WriteLine("Znak plusa [+] ");
            ValidateInputText(inputText, thePlus, true);
        }

        private static void ValidateInputText(string inputText, string regExp,bool isCollection=false,RegexOptions option=RegexOptions.IgnoreCase)
        {
            var regularExp = new Regex(regExp,option);
            
            if (isCollection)
            {
                var matches = regularExp.Matches(inputText);
                foreach (var match in matches)
                {
                    WriteLine($"Fragment '{match}' z tekstu '{inputText}' pasuje do wyrażenia '{regExp}'");
                }
            }
            var singleMatch = Regex.Match(inputText, regExp, option);
            WriteLine($"Fragmennt '{singleMatch}' z tekstu '{inputText}' pasuje do wyrażenia '{regExp}'");
            ReadLine();

        }

        private static void FileInputOutputOperation()
        {
            const string textLine = "Ten plik utworzono podczas nauki C#";
            Write("Podaj nazwę pliku (bez rozszerzenia): ");
            var fileName = ReadLine();
            var fileNameWithPath = $"D:/{fileName}.txt";
            using (var fileStream = File.Create(fileNameWithPath))
            {
                var iBytes = new UTF8Encoding(true).GetBytes(textLine);
                fileStream.Write(iBytes, 0, iBytes.Length);
            }
            WriteLine("Zakończono operację zapisu.");
            ReadLine();
            using (var fileStream = File.OpenRead(fileNameWithPath))
            {
                var bytes = new byte[1024];
                var encoding = new UTF8Encoding(true);
                while (fileStream.Read(bytes, 0, bytes.Length) > 0)
                    WriteLine(encoding.GetString(bytes));
            }
        }

        private static void ExceptionExample()
        {
            WriteLine("Przykład obsługi wyjątków.");
            var example = new ExceptionhandlingExample();
            Write("Podaj dzielną:");
            var dividend = ReadLine();
            Write("Podaj dzielnik:");
            var divisor = ReadLine();
            var quotient = example.Div(Convert.ToInt32(dividend), Convert.ToInt32(divisor));
            WriteLine($"Iloraz liczb {dividend} i {divisor} wynosi {quotient}");
        }

        private static void CallStringCalculatorUpdated()
        {
            WriteLine("Zasady działania:");
            WriteLine("o Operacja akceptuje jedynie dane przekazane w formie łańcucha znaków\n" +
            "o Operacja pobiera 0, 1 lub 2 liczby oddzielone od siebie przecinakami i zwraca ich sumę\n" +
            "o Operacja przyjmuje pusty łańcuch znaków, lecz w razie jego przekazania zwraca 0.\n" +
            "o Przekazanie liczby > 1000 powoduje zgłoszenie wyjątku\n");
            StringCalculatorUpdated calculator = new StringCalculatorUpdated();
            Write("Wpisz liczby rozdzielone przecinkami:");
            var num = ReadLine();
            
            Write($"Suma liczb \"{num}\" wynosi {calculator.Add(num)}");
        }
    }
}