﻿using System;
using Dzien07.Polymorphism;
using Dzien07.Polymorphism.CompileTime;
using Dzien07.Polymorphism.RunTime.Abstract;
using Dzien07.Polymorphism.RunTime.AbstractVirtual;
using static System.Console;

namespace Dzien07
{

    internal class Program
    {
        private static void Main(string[] args)
        {
            ValueTypeMenu();
        }

        private static void ValueTypeMenu()
        {
            int userInput;
            do
            {
                userInput = DisplayMenu();
                switch (userInput)
                {
                    case 1:
                        Clear();
                        MemberVisibilityExample();
                        PressAnyKey();
                        break;
                    case 2:
                        Clear();
                        InheritanceImplementationExample();
                        PressAnyKey();
                        break;
                    case 3:
                        Clear();
                        EncapsulationImplementationExample();
                        PressAnyKey();
                        break;
                    case 4:
                        Clear();
                        AbstractionImplementationExample();
                        PressAnyKey();
                        break;
                    case 5:
                        Clear();
                        PolymorphismImplementationExample();
                        PressAnyKey();
                        break;
                    case 6:
                        Clear();
                        CompileTimePolymorphismImplementationExample();
                        PressAnyKey();
                        break;
                    case 7:
                        Clear();
                        RunTimePolymorphismImplementationExample();
                        PressAnyKey();
                        break;
                    case 8:
                        Clear();
                        RunTimePolymorphismImplementationusingAbstractVirtualExample();
                        PressAnyKey();
                        break;
                }
            } while (userInput != 9);
        }

        private static void RunTimePolymorphismImplementationusingAbstractVirtualExample()
        {
            WriteLine("Zastosowanie polimorfizmu czasu wykonywania z użyciem metody wirtualnej");
            WriteLine();
            RunTimePolymorphismImplementationusingAbstractVirtual implementationusingAbstractVirtual = new RunTimePolymorphismImplementationusingAbstractVirtual();
            implementationusingAbstractVirtual.Run();
        }

        private static void RunTimePolymorphismImplementationExample()
        {
            WriteLine("Przykład zastosowania polimorfizmu czasu wykonywania");
            WriteLine();
            RunTimePolymorphismImplementationusingAbstractClass implementationusingAbstractClass = new RunTimePolymorphismImplementationusingAbstractClass();
            implementationusingAbstractClass.Run();
        }

        private static void CompileTimePolymorphismImplementationExample()
        {
            WriteLine("Przykład zastosowania polimorfizmu czasu kompilacji");
            WriteLine();
            CompileTimePolymorphismImplementation implementation= new CompileTimePolymorphismImplementation();
            implementation.Run();
        }

        private static void PolymorphismImplementationExample()
        {
            WriteLine("Przykład zastosowania polimorfizmu");
            WriteLine();
            PolymorphismImplementation implementation  = new PolymorphismImplementation();
            implementation.Build();
        }

        private static void AbstractionImplementationExample()
        {
            WriteLine("Przykład zastosowania abstrakcji");
            WriteLine();
            AbstractionImplementation abstractionImplementation = new AbstractionImplementation();
            abstractionImplementation.Display();
        }

        private static void EncapsulationImplementationExample()
        {
            WriteLine("Przykład zastosowania hermetyzacji");
            WriteLine();
            EncapsulationImplementation encapsulationImplementation = new EncapsulationImplementation();
            encapsulationImplementation.Display();
        }


        private static void MemberVisibilityExample()
        {
            WriteLine("Przykład widoczności składowych");
            WriteLine();
            var memberVisibility = new MemberVisibility();
            memberVisibility.Display();
        }

        private static void InheritanceImplementationExample()
        {
            WriteLine("Przykład stosowania dziedziczenia");
            WriteLine();
            var person = new Person();
            WriteLine("Szczegóły klasy bazowej Person:");
            person.Detail();
            var author = new Author();
            WriteLine("Klasa pochodna Author:");
            Write("Imię: ");
            author.FirstName = ReadLine();
            Write("Nazwisko: ");
            author.LastName = ReadLine();
            Write("Wiek: ");
            author.Age = Convert.ToInt32(ReadLine());
            author.Detail();

            var editor = new Editor();
            WriteLine("Klasa pochodna Editor:");
            Write("Imię: ");
            editor.FirstName = ReadLine();
            Write("Nazwisko: ");
            editor.LastName = ReadLine();
            Write("Wiek: ");
            editor.Age = Convert.ToInt32(ReadLine());
            editor.Detail();

            var reviewer = new Reviewer();
            WriteLine("Klasa pochodna Reviewer:");
            Write("Imię: ");
            reviewer.FirstName = ReadLine();
            Write("Nazwisko: ");
            reviewer.LastName = ReadLine();
            Write("Wiek: ");
            reviewer.Age = Convert.ToInt32(ReadLine());
            reviewer.Detail();

            // dziedziczenie wielokrotne
            WriteLine("Informacje o książce:");
            Write("Tytuł: ");
            author.Title = ReadLine();
            Write("ISBN: ");
            author.Isbn = ReadLine();
            Write("Opublikowana (T/N):");
            author.Ispublished = ReadLine() == "T";
            ((IBook)author).Detail(); // rzutowanie jest konieczne, gdyż zarówno klasa Person, jak i interfejs IBook dysponują metodą Detail()
        }

        private static void PressAnyKey()
        {
            Write("\n\nNaciśnij dowolny klawisz...");
            ReadKey();
            Clear();
        }

        private static int DisplayMenu()
        {
            return Convert.ToInt32(SelectedMenu());
        }
        private static int SelectedMenu()
        {
            WriteLine("Nauka C# w 7 dni - Przykłady - Dzień 7.");
            WriteLine();
            WriteLine("1. Przykład widoczności składowych");
            WriteLine("2. Przykład stosowania dziedziczenia");
            WriteLine("3. Przykład stosowania hermetyzacji");
            WriteLine("4. Przykład stosowania abstrakcji");
            WriteLine("5. Przykład stosowania polimorfizmu");
            WriteLine("6. Przykład stosowania polimorfizmu czasu kompilacji");
            WriteLine("7. Przykład stosowania polimorfizmu czasu wykonywania");
            WriteLine("8. Przykład stosowania polimorfizmu czasu wykonania z użyciem metody wirtualnej");
            WriteLine("9. Koniec");
            Write("Wybierz opcję (1-9): ");
            var result = ReadLine();
            return string.IsNullOrEmpty(result) ? 0 : Convert.ToInt32(result);
        }
    }
}