﻿using System;
using System.Collections;
using static System.Console;

namespace Dzien05.Lib
{
    public class CollectionGeneric
    {
        public void ArrayListExample(int count)
        {
            var arrayList = new ArrayList();
            var numRandom = new Random(count);
            WriteLine($"Tworzenie kolekcji ArrayList o pojemności: {count}");
            for (var countIndex = 0; countIndex < count; countIndex++)
                arrayList.Add(numRandom.Next(count));
            WriteLine($"Pojemność: {arrayList.Capacity}");
            WriteLine($"Liczba elementów: {arrayList.Count}");

            Write("Początkowa zawartość kolekcji ArrayList: ");
            PrintArrayListContents(arrayList);
            WriteLine();
            arrayList.Reverse();
            Write("Zawartość w odwróconej kolejności: ");
            PrintArrayListContents(arrayList);
            WriteLine();
            Write("Posortowana zawartość kolekcji: ");
            arrayList.Sort();
            PrintArrayListContents(arrayList);
            WriteLine();
            ReadKey();
        }

        public void HashTableExample()
        {
            WriteLine("Tworzenie kolekcji Hashtable.");
            var hashtable = new Hashtable
            {
                {1, "Gustaw Florek"},
                {2, "Wacław Kowalski"},
                {3, "Damian Nowak"},
                {4, "Darek Kruszel"},
                {5, "Marian Wronek"}
            };
            hashtable.Add(11, "Roman");
            WriteLine("Odczyt kluczy kolekcji");
            WriteLine($"Liczba elementów: {hashtable.Count}");
            var fixedSize = hashtable.IsFixedSize ? "ma ustaloną pojemność" : "nie ma ustalonej pojemności";
            WriteLine($"Kolekcja Hashtable {fixedSize}.");
            WriteLine($"Czy kolekcja Hashtable jest przeznaczona tylko do odczytu: {hashtable.IsReadOnly}.");
            foreach (var hashtableKey in hashtable.Keys)
                WriteLine($"Klucz :{hashtableKey} - wartość: {hashtable[hashtableKey]}");
        }

        public void SortedListExample()
        {
            WriteLine("Tworzenie kolekcji SortedList");
            var sortedList = new SortedList
            {
                {1, "Gustaw Florek"},
                {2, "Wacław Kowalski"},
                {3, "Damian Nowak"},
                {4, "Darek Kruszel"},
                {5, "Marian Wronek"},
                {11, "Roma Zymech"}
            };
            WriteLine("Odczyt kluczy kolekcji SortedList");
            WriteLine($"Pojemność: {sortedList.Capacity}");
            WriteLine($"Liczba elementów: {sortedList.Count}");
            var fixedSize = sortedList.IsFixedSize ? "ma stały rozmiar" : "nie ma stałego rozmiaru";
            WriteLine($"Kolekcja SortedList {fixedSize}.");
            WriteLine($"Kolekcja SortedList jest tylko do odczytu: {sortedList.IsReadOnly}.");
            foreach (var key in sortedList.Keys)
                WriteLine($"Klucz :{key} - wartość: {sortedList[key]}");
        }

        public void StackExample()
        {
            WriteLine("Tworzenie stosu");
            var stackList = new Stack();
            stackList.Push("Gustaw Florek");
            stackList.Push("Wacław Kowalski");
            stackList.Push("Damian Nowak");
            stackList.Push("Darek Kruszel");
            stackList.Push("Marian Wronek");

            WriteLine("Odczyt elementów ze stosu");
            ReadingStack(stackList);
            WriteLine();
            WriteLine($"Liczba elementów: {stackList.Count}");

            WriteLine("Dodawanie kolejnych elementów.");
            stackList.Push("Roman Zymech");
            stackList.Push("Szymon Wroński");
            WriteLine();
            WriteLine($"Liczba elementów: {stackList.Count}");
            WriteLine($"Sprawdzenie elementu na wierzchołku stosu:{stackList.Peek()}");
            WriteLine();
            WriteLine("Odczyt elementów na stosie.");
            ReadingStack(stackList);
            WriteLine();
            WriteLine($"Usunięcie elementu: {stackList.Pop()}");
            WriteLine();
            WriteLine("Odczyt elementu z wierzchołka stosu po usunięciu elementu.");
            ReadingStack(stackList);
            ReadLine();
        }

        public void QueueExample()
        {
            WriteLine("Tworzenie kolejki");
            Queue queue = new Queue();
            queue.Enqueue("Gustaw Florek");
            queue.Enqueue("Wacław Kowalski");
            queue.Enqueue("Damian Nowak");
            queue.Enqueue("Darek Kruszel");
            queue.Enqueue("Marian Wronek");

            WriteLine("Odczyt elementów kolejki");
            ReadingQueue(queue);
            WriteLine();
            WriteLine($"Liczba elementów: {queue.Count}");

            WriteLine("Dodawanie kolejnych elementów.");
            queue.Enqueue("Roman Zymech");
            queue.Enqueue("Szymon Wroński");
            WriteLine();
            WriteLine($"Liczba elementów: {queue.Count}");
            WriteLine($"Pobranie elementu bez jego usuwania:{queue.Peek()}");
            WriteLine();
            WriteLine("Odczyt zawartości kolejki.");
            ReadingQueue(queue);
            WriteLine();
            WriteLine($"Usunięcie elementu: {queue.Dequeue()}");
            WriteLine();
            WriteLine("Odczyt elementów po operacji usunięcia.");
            ReadingQueue(queue);
        }

       
        private void ReadingQueue(Queue queue)
        {
            foreach (var item in queue)
                WriteLine($"{item} ");
        }

        private void ReadingStack(Stack stackList)
        {
            foreach (var item in stackList)
                WriteLine($"{item} ");
        }

        private void PrintArrayListContents(ArrayList arrayList)
        {
            foreach (int arr in arrayList)
                Write(arr + " ");
        }
    }
}