/*
 * Decompiled with CFR 0.152.
 */
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;

public class SampleUtilities {
    public static void receiveSynchronizeMessages(String prefix, ConnectionFactory connectionFactory, Queue controlQueue, int count) throws Exception {
        Connection connection = null;
        Session session = null;
        MessageConsumer receiver = null;
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            connection.start();
        }
        catch (Exception e) {
            System.err.println("Problem z po\u0142\u0105czeniem w receiveSynchronizeMessages: " + e.toString());
            e.printStackTrace();
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException ee) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            System.out.println(prefix + "Otrzymywanie komunikat\u00f3w synchronizuj\u0105cych z " + "kolejki steruj\u0105cej; ilo\u015b\u0107 = " + count);
            receiver = session.createConsumer((Destination)controlQueue);
            while (count > 0) {
                receiver.receive();
                System.out.println(prefix + "Otrzymano komunikat synchronizuj\u0105cy; " + " oczekuj\u0119 " + --count + " wi\u0119cej");
            }
        }
        catch (JMSException e) {
            System.err.println("Wystapi\u0142 wyj\u0105tek: " + e.toString());
            throw e;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {}
            }
        }
    }

    public static void sendSynchronizeMessage(String prefix, ConnectionFactory connectionFactory, Queue controlQueue) throws Exception {
        Connection connection = null;
        Session session = null;
        MessageProducer producer = null;
        TextMessage message = null;
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
        }
        catch (Exception e) {
            System.err.println("Problem z po\u0142\u0105czeniem w sendSynchronizeMessage: " + e.toString());
            e.printStackTrace();
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException ee) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            producer = session.createProducer((Destination)controlQueue);
            message = session.createTextMessage();
            message.setText("synchronize");
            System.out.println(prefix + "Wysy\u0142anie komunikat\u00f3w steruj\u0105cych do " + "kolejki steruj\u0105cej");
            producer.send((Message)message);
        }
        catch (JMSException e) {
            System.err.println("Wyst\u0105pi\u0142 wyj\u0105tek: " + e.toString());
            throw e;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {}
            }
        }
    }

    public static class DoneLatch {
        boolean done = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitTillDone() {
            DoneLatch doneLatch = this;
            synchronized (doneLatch) {
                while (!this.done) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void allDone() {
            DoneLatch doneLatch = this;
            synchronized (doneLatch) {
                this.done = true;
                this.notify();
            }
        }
    }
}

