/*
 * Decompiled with CFR 0.152.
 */
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class DurableSubscriberExample {
    static int startindex = 0;
    @Resource(lookup="jms/ConnectionFactory")
    private static ConnectionFactory connectionFactory;
    @Resource(lookup="jms/DurableConnectionFactory")
    private static ConnectionFactory durableConnectionFactory;
    @Resource(lookup="jms/Topic")
    private static Topic topic;
    String conFacName1 = "jms/ConnectionFactory";
    String conFacName2 = "jms/DurableConnectionFactory";
    String topicName = "jms/Topic";

    public void run_program() {
        DurableSubscriber durableSubscriber = new DurableSubscriber();
        MultiplePublisher multiplePublisher = new MultiplePublisher();
        durableSubscriber.startSubscriber();
        multiplePublisher.publishMessages();
        durableSubscriber.closeSubscriber();
        multiplePublisher.publishMessages();
        durableSubscriber.startSubscriber();
        durableSubscriber.closeSubscriber();
        multiplePublisher.finish();
        durableSubscriber.finish();
    }

    public static void main(String[] args) {
        DurableSubscriberExample dse = new DurableSubscriberExample();
        if (args.length != 0) {
            System.out.println("Program nie przyjmuje \u017cadnych argument\u00f3w.");
            System.exit(1);
        }
        System.out.println("Fabryka po\u0142\u0105cze\u0144 bez identyfikatora klienta: " + dse.conFacName1);
        System.out.println("Fabryka po\u0142\u0105cze\u0144 z identyfikatorem klienta: " + dse.conFacName2);
        System.out.println("Nazwa tematu: " + dse.topicName);
        dse.run_program();
        System.exit(0);
    }

    public class MultiplePublisher {
        Connection connection = null;
        MessageProducer producer = null;
        Session session = null;

        public MultiplePublisher() {
            try {
                this.connection = connectionFactory.createConnection();
                this.session = this.connection.createSession(false, 1);
                this.producer = this.session.createProducer((Destination)topic);
            }
            catch (Exception e) {
                System.err.println("Problem z po\u0142\u0105czeniem: " + e.toString());
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
                System.exit(1);
            }
        }

        public void publishMessages() {
            TextMessage message = null;
            int NUMMSGS = 3;
            String MSG_TEXT = "Oto komunikat";
            try {
                int i;
                message = this.session.createTextMessage();
                for (i = startindex; i < startindex + 3; ++i) {
                    message.setText("Oto komunikat " + (i + 1));
                    System.out.println("PRODUCENT: Publikacja komunikatu: " + message.getText());
                    this.producer.send((Message)message);
                }
                this.producer.send(this.session.createMessage());
                startindex = i;
            }
            catch (JMSException e) {
                System.err.println("publishMessages: Wystapi\u0142 wyj\u0105tek: " + e.toString());
            }
        }

        public void finish() {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }
    }

    public class DurableSubscriber {
        Connection connection = null;
        Session session = null;
        TextListener listener = null;
        TopicSubscriber subscriber = null;

        public DurableSubscriber() {
            try {
                this.connection = durableConnectionFactory.createConnection();
                this.session = this.connection.createSession(false, 1);
            }
            catch (Exception e) {
                System.err.println("Problem z po\u0142\u0105czeniem: " + e.toString());
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
                System.exit(1);
            }
        }

        public void startSubscriber() {
            try {
                System.out.println("Uruchamianie subskrybenta");
                this.connection.stop();
                this.subscriber = this.session.createDurableSubscriber(topic, "MakeItLast");
                this.listener = new TextListener();
                this.subscriber.setMessageListener((MessageListener)this.listener);
                this.connection.start();
            }
            catch (JMSException e) {
                System.err.println("startSubscriber: Wyst\u0105pi\u0142 wyj\u0105tek: " + e.toString());
            }
        }

        public void closeSubscriber() {
            try {
                this.listener.monitor.waitTillDone();
                System.out.println("Zamykanie subskrybenta");
                this.subscriber.close();
            }
            catch (JMSException e) {
                System.err.println("closeSubscriber: Wyst\u0105pi\u0142 wyj\u0105tek: " + e.toString());
            }
        }

        public void finish() {
            if (this.connection != null) {
                try {
                    System.out.println("Usuni\u0119cie przypisania do trwa\u0142ej subskrypcji");
                    this.session.unsubscribe("MakeItLast");
                    this.connection.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }

        private class TextListener
        implements MessageListener {
            final SampleUtilities.DoneLatch monitor = new SampleUtilities.DoneLatch();

            private TextListener() {
            }

            public void onMessage(Message message) {
                if (message instanceof TextMessage) {
                    TextMessage msg = (TextMessage)message;
                    try {
                        System.out.println("SUBSKRYBENT: Odczyt komunikatu: " + msg.getText());
                    }
                    catch (JMSException e) {
                        System.err.println("Wyj\u0105tek w onMessage(): " + e.toString());
                    }
                } else {
                    this.monitor.allDone();
                }
            }
        }
    }
}

