/*
 * Decompiled with CFR 0.152.
 */
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class SynchConsumer {
    @Resource(lookup="jms/ConnectionFactory")
    private static ConnectionFactory connectionFactory;
    @Resource(lookup="jms/Queue")
    private static Queue queue;
    @Resource(lookup="jms/Topic")
    private static Topic topic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String destType = null;
        Connection connection = null;
        Session session = null;
        Object dest = null;
        MessageConsumer consumer = null;
        TextMessage message = null;
        if (args.length != 1) {
            System.err.println("Program przyjmuje jeden argument: <typ-celu>");
            System.exit(1);
        }
        destType = args[0];
        System.out.println("Typ celu to " + destType);
        if (!destType.equals("kolejka") && !destType.equals("temat")) {
            System.err.println("Argument musi by\u0107 typu \"kolejka\" lub \"temat\"");
            System.exit(1);
        }
        try {
            dest = destType.equals("kolejka") ? queue : topic;
        }
        catch (Exception e) {
            System.err.println("B\u0142\u0105d ustawiania celu: " + e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            consumer = session.createConsumer((Destination)dest);
            connection.start();
            while (true) {
                Message m;
                if ((m = consumer.receive(1L)) == null) {
                    continue;
                }
                if (m instanceof TextMessage) {
                    message = (TextMessage)m;
                    System.out.println("Otrzymano komunikat: " + message.getText());
                    continue;
                }
                break;
            }
        }
        catch (JMSException e) {
            System.err.println("Wystapi\u0142 wyj\u0105tek: " + e.toString());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {}
            }
        }
    }
}

