// Plik: fig10_13.c
// Stosowanie operatorów bitowych przesunięcia
#include <stdio.h>

void displayBits(unsigned int value); // Prototyp funkcji

int main(void)
{ 
   unsigned int number1 = 960; // Inicjalizacja zmiennej number1

   // Przykład użycia operatora bitowego przesunięcia w lewo
   puts("\nWynik przesunięcia w lewo");
   displayBits(number1);
   puts("8 bitów za pomocą operatora << przedstawia się następująco:");
   displayBits(number1 << 8);

   // Przykład użycia operatora bitowego przesunięcia w prawo
   puts("\nWynik przesunięcia w prawo");
   displayBits(number1);
   puts("8 bitów za pomocą operatora >> przedstawia się następująco:");
   displayBits(number1 >> 8);
}

// Wyświetlenie bitów wartości w postaci liczby całkowitej bez znaku
void displayBits(unsigned int value)
{ 
   // Zadeklarowanie zmiennej displayMask i przesunięcie 31 bitów w lewo
   unsigned int displayMask = 1 << 31;

   printf("%7u = ", value);

   // Iteracja przez tablicę bitów
   for (unsigned int c = 1; c <= 32; ++c) { 
      putchar(value & displayMask ? '1' : '0');
      value <<= 1; // Przesunięcie wartości o 1 w lewo

      if (c % 8 == 0) { // Wyświetlenie spacji po 8 bitach
         putchar(' ');
      }
   }

   putchar('\n');
}
