// Plik: fig05_14.c
// Symulacja gry hazardowej craps
#include <stdio.h>
#include <stdlib.h>
#include <time.h> // Zawiera prototyp dla funkcji time()

// Stała w postaci wyliczenia przedstawiającego stan gry
enum Status { CONTINUE, WON, LOST };

int rollDice(void); // Prototyp funkcji

int main(void)
{ 
   // Użycie bieżącego czasu do zapewnienia prawdziwej losowości generatorowi liczb
   srand(time(NULL));

   int myPoint; // Gracz musi zdobyć ten punkt, aby wygrać
   enum Status gameStatus; // Może zawierać wartości CONTINUE, WON lub LOST
   int sum = rollDice(); // Pierwszy rzut kośćmi

   // Ustalenie stanu gry na podstawie sumy wyrzuconych liczb
   switch(sum) {

      // Wygrana w pierwszym rzucie
      case 7: // 7 zwycięża
      case 11: // 11 zwycięża
         gameStatus = WON; 
         break;

      // Przegrana w pierwszym rzucie
      case 2: // 2 przegrywa
      case 3: // 3 przegrywa
      case 12: // 12 przegrywa
         gameStatus = LOST; 
         break;

      // Zapamiętanie punktu
      default:                  
         gameStatus = CONTINUE; // Gracz powinien kontynuować rzuty
         myPoint = sum; // Zapamiętanie punktu
         printf("Punkt wynosi %d\n", myPoint);
         break; // Opcjonalnie
   }

   // Dopóki gra nie zostanie zakończona
   while (CONTINUE == gameStatus) { // Gracz powinien rzucać kośćmi
      sum = rollDice(); // Ponowny rzut kośćmi

      // Ustalenie stanu gry
      if (sum == myPoint) { // Wygrana przez wyrzucenie punktu
         gameStatus = WON; 
      } 
      else {
         if (7 == sum) { // Przegrana po wyrzuceniu 7
            gameStatus = LOST; 
         } 
      } 
   } 

   // Wyświetlenie komunikatu o wygranej lub przegranej
   if (WON == gameStatus) { // Czy gracz wygrał?
      puts("Gracz wygrał!");
   } 
   else { // Gracz przegrał
      puts("Gracz przegrał!");
   } 
} 

// Rzut kośćmi, obliczenie sumy i wyświetlenie wyników
 int rollDice(void)
{
   int die1 = 1 + (rand() % 6); // Wybór losowej liczby dla pierwszej kości
   int die2 = 1 + (rand() % 6); // Wybór losowej liczby dla drugiej kości

   // Wyświetlenie wyniku tego rzutu
   printf("Gracz wyrzucił %d + %d = %d\n", die1, die2, die1 + die2);
   return die1 + die2; // Zwrot sumy wyrzuconych liczb
} 
