// Plik: Stack.h
// Szablon klasy Stack
#ifndef STACK_H
#define STACK_H
#include <deque>

template< typename T >
class Stack 
{
public:
   // Zwrot elementu znajdującego się na wierzchu stosu
   T& top()
   {
      return stack.front();
   } // Koniec funkcji szablonu top()

   // Umieszczenie elementu na wierzchu stosu
   void push( const T &pushValue )  
   {
      stack.push_front( pushValue );
   } // Koniec funkcji szablonu push()

   // Usunięcie elementu znajdującego się na wierzchu stosu
   void pop()
   {
      stack.pop_front();
   } // Koniec funkcji szablonu pop()

   // Ustalenie, czy stos jest pusty
   bool isEmpty() const   
   { 
      return stack.empty(); 
   } // Koniec funkcji szablonu isEmpty()

   // Zwrot informacji o wielkości stosu
   size_t size() const
   {
      return stack.size();
   } // Koniec funkcji szablonu size()

private:
   std::deque< T > stack; // Wewnętrzna reprezentacja klasy Stack
}; // Koniec szablonu klasy Stack

#endif
