// Plik: CommissionEmployee.h
// Nagłówek klasy CommissionEmployee deklaruje funkcje składowe earnings() i print() jako wirtualne
#ifndef COMMISSION_H
#define COMMISSION_H

#include <string> // Standardowa klasa string w C++

class CommissionEmployee
{
public:
   CommissionEmployee( const std::string &, const std::string &, 
      const std::string &, double = 0.0, double = 0.0 );
   
   void setFirstName( const std::string & ); // Zdefiniowanie imienia
   std::string getFirstName() const; // Pobranie imienia

   void setLastName( const std::string & ); // Zdefiniowanie nazwiska
   std::string getLastName() const; // Pobranie nazwiska

   void setSocialSecurityNumber( const std::string & ); // Zdefiniowanie numeru ubezpieczenia społecznego
   std::string getSocialSecurityNumber() const; // Pobranie numeru ubezpieczenia społecznego

   void setGrossSales( double ); // Zdefiniowanie wielkości sprzedaży
   double getGrossSales() const; // Pobranie wielkości sprzedaży

   void setCommissionRate( double ); // Zdefiniowanie procentowej wysokości prowizji
   double getCommissionRate() const; // Pobranie procentowej wysokości prowizji

   virtual double earnings() const; // Obliczenie wynagrodzenia
   virtual void print() const; // Wyświetlenie zawartości obiektu
private:
   std::string firstName;
   std::string lastName;
   std::string socialSecurityNumber;
   double grossSales; // Tygodniowa wielkość sprzedaży
   double commissionRate; // Prowizja wyrażona w procentach
}; // Koniec klasy CommissionEmployee

#endif
