// Plik: Hugeint.h 
// Definicja klasy HugeInt
#ifndef HUGEINT_H
#define HUGEINT_H

#include <array>
#include <iostream>
#include <string>

class HugeInt
{
   friend std::ostream &operator<<( std::ostream &, const HugeInt & );
public:
   static const int digits = 30; // Maksymalna liczba cyfr liczby typu HugeInt

   HugeInt( long = 0 ); // Konstruktor domyślny i konwersji
   HugeInt( const std::string & ); // Konstruktor konwersji

   // Operator dodawania — HugeInt + HugeInt
   HugeInt operator+( const HugeInt & ) const;

   // Operator dodawania — HugeInt + int
   HugeInt operator+( int ) const;            

   // Operator dodawania.
   // HugeInt + ciąg tekstowy przedstawiający ogromną wartość w postaci liczby całkowitej
   HugeInt operator+( const std::string & ) const;    
private:
   std::array< short, digits > integer;
}; // Koniec klasy HugetInt

#endif
