// Plik: Employee.h
// Definicja klasy Employee ze statycznymi danymi składowymi,
// które śledzą liczbę obiektów Employee znajdujących się w pamięci
#ifndef EMPLOYEE_H
#define EMPLOYEE_H

#include <string>

class Employee 
{
public:
   Employee( const std::string &, const std::string & ); // Konstruktor
   ~Employee(); // Destruktor
   std::string getFirstName() const; // Zwrot imienia
   std::string getLastName() const; // Zwrot nazwiska

   // Statyczna funkcja składowa      
   static unsigned int getCount(); // Zwrot liczby utworzonych obiektów
private:
   std::string firstName;
   std::string lastName;

   // Dane statyczne                                     
   static unsigned int count; // Liczba utworzonych obiektów
}; // Koniec klasy Employee

#endif
