// Plik: fig10_09.c
// Stosowanie operatorów bitowych i,
// lub, wyłączającego lub i dopełnienia.
#include <stdio.h>

void displayBits(unsigned int value); // Prototyp funkcji

int main(void)
{ 
   // Przykład użycia operatora bitowego i (&)
   unsigned int number1 = 65535;
   unsigned int mask = 1;
   puts("Wynik połączenia wartości");
   displayBits(number1);
   displayBits(mask);
   puts("za pomocą operatora bitowego i (&):");
   displayBits(number1 & mask);

   // Przykład użycia operatora bitowego lub (|)
   number1 = 15;
   unsigned int setBits = 241;
   puts("\nWynik połączenia wartości");
   displayBits(number1);
   displayBits(setBits);
   puts("za pomocą operatora bitowego lub (|):");
   displayBits(number1 | setBits);

   // Przykład użycia operatora bitowego wykluczającego lub (^)
   number1 = 139;
   unsigned int number2 = 199;
   puts("\nWynik połączenia wartości");
   displayBits(number1);
   displayBits(number2);
   puts("za pomocą operatora bitowego wykluczającego lub (^):");
   displayBits(number1 ^ number2);

   // Przykład użycia operatora bitowego dopełnienia (~)
   number1 = 21845;
   puts("\nWynik użycia operatora bitowego dopełnienia");
   displayBits(number1);
   puts("przedstawia się następująco:");
   displayBits(~number1);
}

// Wyświetlenie bitów wartości w postaci liczby całkowitej bez znaku
void displayBits(unsigned int value)
{ 
   // Zadeklarowanie zmiennej displayMask i przesunięcie 31 bitów w lewo
   unsigned int displayMask = 1 << 31;

   printf("%10u = ", value);

   // Iteracja przez tablicę bitów
   for (unsigned int c = 1; c <= 32; ++c) { 
      putchar(value & displayMask ? '1' : '0');
      value <<= 1; // Przesunięcie wartości o 1 w lewo

      if (c % 8 == 0) { // Wyświetlenie spacji po 8 bitach
         putchar(' ');
      }
   }

   putchar('\n');
}
