// Plik: fig10_03.c
// Program wykorzystujący struktury do symulacji tasowania i rozdawania kart
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define CARDS 52
#define FACES 13

// Definicja struktury card
struct card {
   const char *face; // Definicja wskaźnika face
   const char *suit; // Definicja wskaźnika suit
};

typedef struct card Card; // Nowa nazwa typu dla struktury card

// Prototypy funkcji
void fillDeck(Card * const wDeck, const char * wFace[], 
   const char * wSuit[]);
void shuffle(Card * const wDeck);
void deal(const Card * const wDeck);

int main(void)
{ 
   Card deck[CARDS]; // Zdefiniowanie tablicy Cards

   // Inicjalizacja wskaźników tablicy
   const char *face[] = { "as", "dwójka", "trójka", "czwórka", "piątka",
      "szóstka", "siódemka", "ósemka", "dziewiątka", "dziesiątka",
      "walet", "królowa", "król"};

   // Inicjalizacja wskaźników tablicy
   const char *suit[] = { "kier", "karo", "trefl", "pik"};

   srand(time(NULL)); // Zapewnienie losowości

   fillDeck(deck, face, suit); // Wczytanie talii kart
   shuffle(deck); // Potasowanie kart
   deal(deck); // Rozdanie wszystkich 52 kart
}

// Umieszczenie ciągów tekstowych w strukturach Card
void fillDeck(Card * const wDeck , const char * wFace[], 
   const char * wSuit[])
{ 
   // Iteracja przez tablicę wDeck
   for (size_t i = 0; i < CARDS; ++i) { 
      wDeck[i].face = wFace[i % FACES];
      wDeck[i].suit = wSuit[i / FACES];
   }
}

// Tasowanie kart
void shuffle(Card * const wDeck)
{ 
   // Iteracja przez tablicę wDeck i losowa zamiana kart miejscami
   for (size_t i = 0; i < CARDS; ++i) { 
      size_t j = rand() % CARDS;
      Card temp = wDeck[i];
      wDeck[i] = wDeck[j];
      wDeck[j] = temp;
   }
}

// Rozdanie kart
void deal(const Card * const wDeck )
{ 
   // Iteracja przez tablicę wDeck
   for (size_t i = 0; i < CARDS; ++i) {
      printf("%10s %-5s%s", wDeck[i].face, wDeck[i].suit,
         (i + 1) % 4 ? "  " : "\n");
   }
}
