// Plik: BasePlusCommissionEmployee.h
// Klasa BasePlusCommissionEmployee dziedziczy 
// po klasie CommissionEmployee
#ifndef BASEPLUS_H
#define BASEPLUS_H

#include <string> // Standardowa klasa string w C++
#include "CommissionEmployee.h" // Deklaracja klasy CommissionEmployee

class BasePlusCommissionEmployee : public CommissionEmployee
{
public:
   BasePlusCommissionEmployee( const std::string &, const std::string &, 
      const std::string &, double = 0.0, double = 0.0, double = 0.0 );
   
   void setBaseSalary( double ); // Zdefiniowanie wynagrodzenia zasadniczego
   double getBaseSalary() const; // Pobranie wynagrodzenia zasadniczego

   double earnings() const; // Obliczenie wynagrodzenia
   void print() const; // Wyświetlenie zawartości obiektu BasePlusCommissionEmployee
private:
   double baseSalary; // Wynagrodzenie zasadnicze
}; // Koniec klasy BasePlusCommissionEmployee

#endif
