// Plik: Time.cpp 
// Definicje funkcji składowych klasy Time
#include <iostream>
#include <iomanip>
#include <stdexcept>
#include "Time.h" // Definicja klasy Time
using namespace std;

// Funkcja konstruktora inicjalizuje prywatne dane składowe
// Wywołuje funkcję składową setTime() w celu przypisania wartości zmiennym
// Wartości domyślne to 0 (zajrzyj do definicji klasy)
Time::Time( int hr, int min, int sec ) 
{
   setTime( hr, min, sec ); 
} // Koniec konstruktora klasy Time

// Przypisanie wartości godzinie, minucie i sekundzie
Time &Time::setTime( int h, int m, int s ) // Zwróć uwagę na typ wartości zwrotnej Time &
{
   setHour( h );
   setMinute( m );
   setSecond( s ); 
   return *this; // Umożliwienie kaskadowych wywołań funkcji składowych
} // Koniec funkcji setTime()

// Zdefiniowanie wartości reprezentującej godzinę
Time &Time::setHour( int h ) // Zwróć uwagę na typ wartości zwrotnej Time &
{
   if ( h >= 0 && h < 24 )
      hour = h;
   else
      throw invalid_argument( "Wartość godziny musi mieścić się w przedziale 0-23." );

   return *this; // Umożliwienie kaskadowych wywołań funkcji składowych
} // Koniec funkcji setHour()

// Zdefiniowanie wartości reprezentującej minutę
Time &Time::setMinute( int m ) // Zwróć uwagę na typ wartości zwrotnej Time &
{
   if ( m >= 0 && m < 60 )
      minute = m;
   else
      throw invalid_argument( "Wartość minuty musi mieścić się w przedziale 0-59." );

   return *this; // Umożliwienie kaskadowych wywołań funkcji składowych
} // Koniec funkcji setMinute()

// Zdefiniowanie wartości reprezentującej sekundę
Time &Time::setSecond( int s ) // Zwróć uwagę na typ wartości zwrotnej Time &
{
   if ( s >= 0 && s < 60 )
      second = s;
   else
      throw invalid_argument( "Wartość sekundy musi mieścić się w przedziale 0-59." );

   return *this; // Umożliwienie kaskadowych wywołań funkcji składowych
} // Koniec funkcji setSecond()

// Pobranie wartości reprezentującej godzinę
unsigned int Time::getHour() const 
{ 
   return hour; 
} // Koniec funkcji getHour()

// Pobranie wartości reprezentującej minutę
unsigned int Time::getMinute() const 
{ 
   return minute; 
} // Koniec funkcji getMinute()

// Pobranie wartości reprezentującej sekundę
unsigned int Time::getSecond() const 
{ 
   return second; 
} // Koniec funkcji getSecond()

// Wyświetlenie godziny w formacie czasu uniwersalnego (GG:MM:SS)
void Time::printUniversal() const
{
   cout << setfill( '0' ) << setw( 2 ) << hour << ":"
      << setw( 2 ) << minute << ":" << setw( 2 ) << second;
} // Koniec funkcji printUniversal()

// Wyświetlenie godziny w formacie czasu uniwersalnego (GG:MM:SS AM lub PM)
void Time::printStandard() const
{
   cout << ( ( hour == 0 || hour == 12 ) ? 12 : hour % 12 )
      << ":" << setfill( '0' ) << setw( 2 ) << minute
      << ":" << setw( 2 ) << second << ( hour < 12 ? " AM" : " PM" );
} // Koniec funkcji printStandard()
