// Plik: GradeBook.h
// Definicja klasy GradeBook umieszczona w innym pliku niż plik zawierający funkcję main()
#include <iostream> 
#include <string> // Klasa GradeBook używa standardowej w C++ klasy string

// Definicja klasy GradeBook
class GradeBook
{
public:
   // Konstruktor inicjalizuje courseName z ciągiem tekstowym dostarczonym w postaci argumentu
   explicit GradeBook( std::string name )
      : courseName( name ) // Metoda inicjalizacyjna elementu składowego przeprowadza inicjalizację courseName 
   {                                                                      
      // Pusta definicja
   } // Koniec konstruktora GradeBook

   // Funkcja pozwalająca zdefiniować nazwę kursu
   void setCourseName( std::string name )
   {
      courseName = name; // Nazwa kursu jest przechowywana w obiekcie
   } // Koniec funkcji setCourseName()

   // Funkcja pobierająca nazwę kursu
   std::string getCourseName() const
   {
      return courseName; // Zwrot wartości courseName obiektu
   } // Koniec funkcji getCourseName()

   // Wyświetlenie komunikatu powitalnego użytkownikowi klasy GradeBook
   void displayMessage() const
   {
      // Wywołanie funkcji getCourseName() w celu pobrania wartości courseName
      std::cout << "Witaj w dzienniku elektronicznym kursu\n" << getCourseName()
         << "!" << std::endl;
   } // Koniec funkcji displayMessage()
private:
   std::string courseName; // Nazwa kursu reprezentowanego przez dany obiekt GradeBook
}; // Koniec klasy GradeBook
