// Plik: figE_11.c
// Sekwencyjnie przeprowadzane obliczenia ciągu Fibonacciego
#include <stdio.h>
#include <time.h>

unsigned long long int fibonacci(unsigned int n); // Prototyp funkcji

// Funkcja main() rozpoczyna wykonywanie programu
int main(void)
{
   puts("Sekwencyjne wywołania funkcji fibonacci(50) i fibonacci(49)");

   // Obliczanie ciągu Fibonacciego dla wartości 50
   time_t startTime1 = time(NULL);
   puts("Obliczenia dla wywołania fibonacci(50)");
   unsigned long long int result1 = fibonacci(50);
   time_t endTime1 = time(NULL);

   printf("fibonacci(%u) = %llu\n", 50, result1);
   printf("Czas obliczeń = %f minut(y)\n\n", 
      difftime(endTime1, startTime1) / 60.0);

   time_t startTime2 = time(NULL);
   puts("Obliczenia dla wywołania fibonacci(49)");
   unsigned long long int result2 = fibonacci(49);
   time_t endTime2 = time(NULL);

   printf("fibonacci(%u) = %llu\n", 49, result2);
   printf("Czas obliczeń = %f minut(y)\n\n", 
      difftime(endTime2, startTime2) / 60.0);

   printf("Całkowity czas obliczeń = %f minut(y)\n", 
      difftime(endTime2, startTime1) / 60.0);
} 

// Rekurencyjne obliczanie liczb ciągu Fibonacciego
unsigned long long int fibonacci(unsigned int n)   
{                                                    
   // Przypadek bazowy                                      
   if (0 == n || 1 == n) {                         
      return n;                                      
   }                                        
   else { // Krok rekurencyjny                          
      return fibonacci(n - 1) + fibonacci(n - 2);
   }                                      
}
